/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;
import org.opennms.netmgt.events.api.EventIpcBroadcaster;
import org.opennms.netmgt.events.api.EventProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class EventIpcBroadcastProcessor
implements EventProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventIpcBroadcastProcessor.class);
    private EventIpcBroadcaster m_eventIpcBroadcaster;
    private final Timer broadcastTimer;

    public EventIpcBroadcastProcessor(MetricRegistry registry) {
        this.broadcastTimer = Objects.requireNonNull(registry).timer("events.process.broadcast");
    }

    public void afterPropertiesSet() throws IllegalStateException {
        Assert.state((this.m_eventIpcBroadcaster != null ? 1 : 0) != 0, (String)"property eventIpcBroadcaster must be set");
    }

    public void process(Header eventHeader, Event event) {
        if (event.getLogmsg() != null && event.getLogmsg().getDest().equals("suppress")) {
            LOG.debug("process: skip sending event {} to other daemons because is marked as suppress", (Object)event.getUei());
        } else {
            try (Timer.Context context = this.broadcastTimer.time();){
                this.m_eventIpcBroadcaster.broadcastNow(event);
            }
        }
    }

    public EventIpcBroadcaster getEventIpcBroadcaster() {
        return this.m_eventIpcBroadcaster;
    }

    public void setEventIpcBroadcaster(EventIpcBroadcaster eventIpcManager) {
        this.m_eventIpcBroadcaster = eventIpcManager;
    }
}

