/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.commands;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;

@Command(scope="events", name="stress", description="Stress the event bus with generated events.", detailedDescription="Generate newSuspect events with increasing IP addresses:\n\tevents:stress -u uei.opennms.org/internal/discovery/newSuspect -e 10 -s 1 -j \"i=i+1\" -j \"eb.setInterface(iputils:int2ip(167837696 + i))\"")
public class StressCommand
extends OsgiCommandSupport {
    private static final String EVENT_SOURCE = "stress";
    private EventForwarder eventForwarder;
    @Option(name="-e", aliases={"--eps"}, description="events per seconds to generate per thread, defaults to 300", required=false, multiValued=false)
    int eventsPerSecondPerThread = 300;
    @Option(name="-t", aliases={"--threads"}, description="number of threads used to generated events, defaults to 1", required=false, multiValued=false)
    int numberOfThreads = 1;
    @Option(name="-u", aliases={"--uei"}, description="events uei", required=false, multiValued=false)
    String eventUei = "uei.opennms.org/alarms/trigger";
    @Option(name="-s", aliases={"--seconds"}, description="number of seconds to run, defaults to 60", required=false, multiValued=false)
    int numSeconds = 60;
    @Option(name="-r", aliases={"--report"}, description="number of seconds after which the report should be generated, defaults to 15", required=false, multiValued=false)
    int reportIntervalInSeconds = 15;
    @Option(name="-j", aliases={"--jexl"}, description="JEXL expressions", required=false, multiValued=true)
    List<String> jexlExpressions = null;
    @Option(name="-b", aliases={"--batch-size"}, description="The size of the log (batch size)", required=false, multiValued=false)
    int batchSize = 1;
    @Option(name="-n", aliases={"--node-id"}, description="The node id to associate with the generated event")
    Integer eventNodeId = null;
    @Option(name="-i", aliases={"--interface"}, description="The ip interface to associate with the generated event")
    String eventIpInterface = null;
    @Option(name="-x", aliases={"--sync"}, description="Use synchronous instead of asynchronous calls", required=false, multiValued=false)
    boolean isSynchronous = false;
    private final MetricRegistry metrics = new MetricRegistry();
    private final Meter eventsGenerated = this.metrics.meter("events-generated");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() {
        ConsoleReporter reporter;
        block11: {
            this.eventsPerSecondPerThread = Math.max(1, this.eventsPerSecondPerThread);
            this.numberOfThreads = Math.max(1, this.numberOfThreads);
            this.numSeconds = Math.max(1, this.numSeconds);
            this.reportIntervalInSeconds = Math.max(1, this.reportIntervalInSeconds);
            this.batchSize = Math.max(1, this.batchSize);
            boolean useJexl = this.jexlExpressions != null && this.jexlExpressions.size() > 0;
            double eventsPerSecond = this.eventsPerSecondPerThread * this.numberOfThreads;
            System.out.printf("Generating %d events per second accross %d threads for %d seconds\n", this.eventsPerSecondPerThread, this.numberOfThreads, this.numSeconds);
            System.out.printf("\t with UEI: %s\n", this.eventUei);
            System.out.printf("\t with batch size: %d\n", this.batchSize);
            System.out.printf("\t with synchronous calls: %s\n", this.isSynchronous);
            System.out.printf("Which will yield an effective\n", new Object[0]);
            System.out.printf("\t %.2f events per second\n", eventsPerSecond);
            System.out.printf("\t %.2f total events\n", eventsPerSecond * (double)this.numSeconds);
            if (useJexl) {
                System.out.printf("Using JEXL expressions:\n", new Object[0]);
                for (String jexlExpression : this.jexlExpressions) {
                    System.out.printf("\t%s\n", jexlExpression);
                }
            }
            reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Event Generator #%d").build();
            ExecutorService executor = Executors.newFixedThreadPool(this.numberOfThreads, threadFactory);
            System.out.println("Starting.");
            try {
                reporter.start((long)this.reportIntervalInSeconds, TimeUnit.SECONDS);
                for (int i = 0; i < this.numberOfThreads; ++i) {
                    EventGenerator eventGenerator = useJexl ? new JexlEventGenerator(this.jexlExpressions) : new EventGenerator();
                    executor.execute(eventGenerator);
                }
                System.out.println("Started.");
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.numSeconds));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    System.out.println("Stopping.");
                    executor.shutdownNow();
                    if (!executor.awaitTermination(2L, TimeUnit.MINUTES)) {
                        System.err.println("The threads did not stop in time.");
                        break block11;
                    }
                    System.out.println("Stopped.");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                reporter.stop();
            }
        }
        reporter.report();
        return null;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public static class IpUtils {
        public static InetAddress int2ip(int k) {
            byte[] bytes = BigInteger.valueOf(k).toByteArray();
            try {
                return InetAddress.getByAddress(bytes);
            }
            catch (UnknownHostException e) {
                System.err.printf("Failed to convert %d to an InetAddress.", k);
                return null;
            }
        }
    }

    private class EventGenerator
    implements Runnable {
        private EventGenerator() {
        }

        @Override
        public void run() {
            RateLimiter rateLimiter = RateLimiter.create((double)StressCommand.this.eventsPerSecondPerThread);
            do {
                Log log = new Log();
                log.setEvents(new Events());
                for (int i = 0; i < StressCommand.this.batchSize; ++i) {
                    log.getEvents().getEventCollection().add(this.getNextEvent());
                }
                rateLimiter.acquire(StressCommand.this.batchSize);
                if (StressCommand.this.isSynchronous) {
                    StressCommand.this.eventForwarder.sendNowSync(log);
                } else {
                    StressCommand.this.eventForwarder.sendNow(log);
                }
                StressCommand.this.eventsGenerated.mark((long)StressCommand.this.batchSize);
            } while (!Thread.interrupted());
        }

        public Event getNextEvent() {
            EventBuilder eb = new EventBuilder(StressCommand.this.eventUei, StressCommand.EVENT_SOURCE);
            if (StressCommand.this.eventNodeId != null) {
                eb.setNodeid((long)StressCommand.this.eventNodeId.intValue());
            }
            if (StressCommand.this.eventIpInterface != null) {
                eb.setInterface(InetAddressUtils.addr((String)StressCommand.this.eventIpInterface));
            }
            return eb.getEvent();
        }
    }

    private class JexlEventGenerator
    extends EventGenerator {
        private final JexlContext context = new MapContext();
        private final List<Expression> expressions = new ArrayList<Expression>();

        public JexlEventGenerator(List<String> jexlExpressions) {
            JexlEngine engine = new JexlEngine();
            HashMap functions = Maps.newHashMap();
            functions.put("iputils", IpUtils.class);
            engine.setFunctions((Map)functions);
            for (String jexlExpression : jexlExpressions) {
                this.expressions.add(engine.createExpression(jexlExpression));
            }
        }

        @Override
        public Event getNextEvent() {
            EventBuilder eb = new EventBuilder(StressCommand.this.eventUei, StressCommand.EVENT_SOURCE);
            this.context.set("eb", (Object)eb);
            for (Expression expression : this.expressions) {
                expression.evaluate(this.context);
            }
            return eb.getEvent();
        }
    }
}

