/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.IValue;

public final class ImmutableValue
implements IValue {
    private final String content;
    private final String type;
    private final String encoding;
    private final Boolean expand;

    private ImmutableValue(Builder builder) {
        this.content = builder.content;
        this.type = builder.type;
        this.encoding = builder.encoding;
        this.expand = builder.expand;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IValue value) {
        return new Builder(value);
    }

    public static IValue immutableCopy(IValue value) {
        if (value == null || value instanceof ImmutableValue) {
            return value;
        }
        return ImmutableValue.newBuilderFrom(value).build();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Boolean isExpand() {
        return this.expand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableValue that = (ImmutableValue)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.type, that.type) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.expand, that.expand);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.type, this.encoding, this.expand);
    }

    public String toString() {
        return "ImmutableValue{content='" + this.content + '\'' + ", type='" + this.type + '\'' + ", encoding='" + this.encoding + '\'' + ", expand=" + this.expand + '}';
    }

    public static final class Builder {
        private String content;
        private String type;
        private String encoding;
        private Boolean expand;

        private Builder() {
        }

        public Builder(IValue value) {
            this.content = value.getContent();
            this.type = value.getType();
            this.encoding = value.getEncoding();
            this.expand = value.isExpand();
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setExpand(Boolean expand) {
            this.expand = expand;
            return this;
        }

        public ImmutableValue build() {
            return new ImmutableValue(this);
        }
    }
}

