/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.IScript;

public final class ImmutableScript
implements IScript {
    private final String content;
    private final String language;

    private ImmutableScript(Builder builder) {
        this.content = builder.content;
        this.language = builder.language;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IScript script) {
        return new Builder(script);
    }

    public static IScript immutableCopy(IScript script) {
        if (script == null || script instanceof ImmutableScript) {
            return script;
        }
        return ImmutableScript.newBuilderFrom(script).build();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableScript that = (ImmutableScript)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.language, that.language);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.language);
    }

    public String toString() {
        return "ImmutableScript{content='" + this.content + '\'' + ", language='" + this.language + '\'' + '}';
    }

    public static final class Builder {
        private String content;
        private String language;

        private Builder() {
        }

        public Builder(IScript script) {
            this.content = script.getContent();
            this.language = script.getLanguage();
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        public ImmutableScript build() {
            return new ImmutableScript(this);
        }
    }
}

