/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.ImmutableCollections;
import org.opennms.core.utils.MutableCollections;
import org.opennms.netmgt.events.api.model.IMask;
import org.opennms.netmgt.events.api.model.IMaskElement;
import org.opennms.netmgt.events.api.model.ImmutableMaskElement;

public final class ImmutableMask
implements IMask {
    private final List<IMaskElement> maskElements;

    private ImmutableMask(Builder builder) {
        this.maskElements = ImmutableCollections.with(ImmutableMaskElement::immutableCopy).newList((Collection)builder.maskElements);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IMask fromMask) {
        return new Builder(fromMask);
    }

    public static IMask immutableCopy(IMask mask) {
        if (mask == null || mask instanceof ImmutableMask) {
            return mask;
        }
        return ImmutableMask.newBuilderFrom(mask).build();
    }

    @Override
    public List<IMaskElement> getMaskelementCollection() {
        return this.maskElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMask that = (ImmutableMask)o;
        return Objects.equals(this.maskElements, that.maskElements);
    }

    public int hashCode() {
        return Objects.hash(this.maskElements);
    }

    public String toString() {
        return "ImmutableMask{maskElements=" + this.maskElements + '}';
    }

    public static final class Builder {
        private List<IMaskElement> maskElements;

        private Builder() {
        }

        public Builder(IMask mask) {
            this.maskElements = MutableCollections.copyListFromNullable(mask.getMaskelementCollection());
        }

        public Builder setMaskElements(List<IMaskElement> maskElements) {
            this.maskElements = maskElements;
            return this;
        }

        public ImmutableMask build() {
            return new ImmutableMask(this);
        }
    }
}

