/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.event;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.DateTimeAdapter;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Autoacknowledge;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Correlation;
import org.opennms.netmgt.xml.event.Forward;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Mask;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Script;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Tticket;

@XmlRootElement(name="event")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Event
implements Serializable {
    private static final long serialVersionUID = 6997816158234653400L;
    @XmlAttribute(name="uuid")
    private String _uuid;
    @XmlElement(name="dbid")
    private Integer _dbid;
    @XmlElement(name="dist-poller")
    private String _distPoller;
    @XmlElement(name="creation-time")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date _creationTime;
    @XmlElement(name="master-station")
    private String _masterStation;
    @XmlElement(name="mask")
    private Mask _mask;
    @XmlElement(name="uei")
    private String _uei;
    @XmlElement(name="source")
    private String _source;
    @XmlElement(name="nodeid")
    private Long _nodeid;
    @XmlElement(name="time")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date _time;
    @XmlElement(name="host")
    private String _host;
    @XmlElement(name="interface")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress _interfaceAddress;
    private transient String _interfaceString;
    @XmlElement(name="snmphost")
    private String _snmphost;
    @XmlElement(name="service")
    private String _service;
    @XmlElement(name="snmp")
    private Snmp _snmp;
    @XmlElementWrapper(name="parms")
    @XmlElement(name="parm")
    private List<Parm> _parms;
    @XmlElement(name="descr")
    private String _descr;
    @XmlElement(name="logmsg")
    private Logmsg _logmsg;
    @XmlElement(name="severity")
    private String _severity;
    @XmlElement(name="pathoutage")
    private String _pathoutage;
    @XmlElement(name="correlation")
    private Correlation _correlation;
    @XmlElement(name="operinstruct")
    private String _operinstruct;
    @XmlElement(name="autoaction")
    private List<Autoaction> _autoactionList = new ArrayList<Autoaction>();
    @XmlElement(name="operaction")
    private List<Operaction> _operactionList = new ArrayList<Operaction>();
    @XmlElement(name="autoacknowledge")
    private Autoacknowledge _autoacknowledge;
    @XmlElement(name="loggroup")
    private List<String> _loggroupList = new ArrayList<String>();
    @XmlElement(name="tticket")
    private Tticket _tticket;
    @XmlElement(name="forward")
    private List<Forward> _forwardList = new ArrayList<Forward>();
    @XmlElement(name="script")
    private List<Script> _scriptList = new ArrayList<Script>();
    @XmlElement(name="ifIndex")
    private Integer _ifIndex;
    @XmlElement(name="ifAlias")
    private String _ifAlias;
    @XmlElement(name="mouseovertext")
    private String _mouseovertext;
    @XmlElement(name="alarm-data")
    private AlarmData _alarmData;

    public void addAutoaction(Autoaction vAutoaction) throws IndexOutOfBoundsException {
        this._autoactionList.add(vAutoaction);
    }

    public void addAutoaction(int index, Autoaction vAutoaction) throws IndexOutOfBoundsException {
        this._autoactionList.add(index, vAutoaction);
    }

    public void addForward(Forward vForward) throws IndexOutOfBoundsException {
        this._forwardList.add(vForward);
    }

    public void addForward(int index, Forward vForward) throws IndexOutOfBoundsException {
        this._forwardList.add(index, vForward);
    }

    public void addLoggroup(String vLoggroup) throws IndexOutOfBoundsException {
        this._loggroupList.add(vLoggroup);
    }

    public void addLoggroup(int index, String vLoggroup) throws IndexOutOfBoundsException {
        this._loggroupList.add(index, vLoggroup);
    }

    public void addOperaction(Operaction vOperaction) throws IndexOutOfBoundsException {
        this._operactionList.add(vOperaction);
    }

    public void addParm(Parm parm) {
        if (this._parms == null) {
            this._parms = new ArrayList<Parm>();
        }
        this._parms.add(parm);
    }

    public void addOperaction(int index, Operaction vOperaction) throws IndexOutOfBoundsException {
        this._operactionList.add(index, vOperaction);
    }

    public void addScript(Script vScript) throws IndexOutOfBoundsException {
        this._scriptList.add(vScript);
    }

    public void addScript(int index, Script vScript) throws IndexOutOfBoundsException {
        this._scriptList.add(index, vScript);
    }

    public void deleteDbid() {
        this._dbid = null;
    }

    public void deleteIfIndex() {
        this._ifIndex = null;
    }

    public void deleteNodeid() {
        this._nodeid = null;
    }

    public Enumeration<Autoaction> enumerateAutoaction() {
        return Collections.enumeration(this._autoactionList);
    }

    public Enumeration<Forward> enumerateForward() {
        return Collections.enumeration(this._forwardList);
    }

    public Enumeration<String> enumerateLoggroup() {
        return Collections.enumeration(this._loggroupList);
    }

    public Enumeration<Operaction> enumerateOperaction() {
        return Collections.enumeration(this._operactionList);
    }

    public Enumeration<Script> enumerateScript() {
        return Collections.enumeration(this._scriptList);
    }

    public AlarmData getAlarmData() {
        return this._alarmData;
    }

    public Autoacknowledge getAutoacknowledge() {
        return this._autoacknowledge;
    }

    public Autoaction getAutoaction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._autoactionList.size()) {
            throw new IndexOutOfBoundsException("getAutoaction: Index value '" + index + "' not in range [0.." + (this._autoactionList.size() - 1) + "]");
        }
        return this._autoactionList.get(index);
    }

    public Autoaction[] getAutoaction() {
        return this._autoactionList.toArray(new Autoaction[0]);
    }

    public List<Autoaction> getAutoactionCollection() {
        return this._autoactionList;
    }

    public int getAutoactionCount() {
        return this._autoactionList.size();
    }

    public Correlation getCorrelation() {
        return this._correlation;
    }

    public Date getCreationTime() {
        return this._creationTime;
    }

    public Integer getDbid() {
        return this._dbid == null ? 0 : this._dbid;
    }

    public String getDescr() {
        return this._descr;
    }

    public String getDistPoller() {
        return this._distPoller;
    }

    public Forward getForward(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._forwardList.size()) {
            throw new IndexOutOfBoundsException("getForward: Index value '" + index + "' not in range [0.." + (this._forwardList.size() - 1) + "]");
        }
        return this._forwardList.get(index);
    }

    public Forward[] getForward() {
        return this._forwardList.toArray(new Forward[0]);
    }

    public List<Forward> getForwardCollection() {
        return this._forwardList;
    }

    public int getForwardCount() {
        return this._forwardList.size();
    }

    public String getHost() {
        return this._host;
    }

    public String getIfAlias() {
        return this._ifAlias;
    }

    public Integer getIfIndex() {
        return this._ifIndex == null ? 0 : this._ifIndex;
    }

    public String getInterface() {
        if (this._interfaceString == null) {
            this._interfaceString = InetAddressUtils.str((InetAddress)this._interfaceAddress);
        }
        return this._interfaceString;
    }

    @XmlTransient
    public InetAddress getInterfaceAddress() {
        return this._interfaceAddress;
    }

    public String getLoggroup(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._loggroupList.size()) {
            throw new IndexOutOfBoundsException("getLoggroup: Index value '" + index + "' not in range [0.." + (this._loggroupList.size() - 1) + "]");
        }
        return this._loggroupList.get(index);
    }

    public String[] getLoggroup() {
        return this._loggroupList.toArray(new String[0]);
    }

    public List<String> getLoggroupCollection() {
        return this._loggroupList;
    }

    public int getLoggroupCount() {
        return this._loggroupList.size();
    }

    public Logmsg getLogmsg() {
        return this._logmsg;
    }

    public Mask getMask() {
        return this._mask;
    }

    public String getMasterStation() {
        return this._masterStation;
    }

    public String getMouseovertext() {
        return this._mouseovertext;
    }

    public Long getNodeid() {
        return this._nodeid == null ? 0L : this._nodeid;
    }

    public Operaction getOperaction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._operactionList.size()) {
            throw new IndexOutOfBoundsException("getOperaction: Index value '" + index + "' not in range [0.." + (this._operactionList.size() - 1) + "]");
        }
        return this._operactionList.get(index);
    }

    public Operaction[] getOperaction() {
        return this._operactionList.toArray(new Operaction[0]);
    }

    public List<Operaction> getOperactionCollection() {
        return this._operactionList;
    }

    public int getOperactionCount() {
        return this._operactionList.size();
    }

    public String getOperinstruct() {
        return this._operinstruct;
    }

    public List<Parm> getParmCollection() {
        return this._parms == null ? Collections.emptyList() : this._parms;
    }

    public Parm getParm(String key) {
        if (this._parms == null) {
            return null;
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key cannot be null!");
        }
        for (Parm parm : this._parms) {
            if (!key.equals(parm.getParmName())) continue;
            return parm;
        }
        return null;
    }

    public String getPathoutage() {
        return this._pathoutage;
    }

    public Script getScript(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._scriptList.size()) {
            throw new IndexOutOfBoundsException("getScript: Index value '" + index + "' not in range [0.." + (this._scriptList.size() - 1) + "]");
        }
        return this._scriptList.get(index);
    }

    public Script[] getScript() {
        return this._scriptList.toArray(new Script[0]);
    }

    public List<Script> getScriptCollection() {
        return this._scriptList;
    }

    public int getScriptCount() {
        return this._scriptList.size();
    }

    public String getService() {
        return this._service;
    }

    public String getSeverity() {
        return this._severity;
    }

    public Snmp getSnmp() {
        return this._snmp;
    }

    public String getSnmphost() {
        return this._snmphost;
    }

    public String getSource() {
        return this._source;
    }

    public Date getTime() {
        return this._time;
    }

    public Tticket getTticket() {
        return this._tticket;
    }

    public String getUei() {
        return this._uei;
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean hasDbid() {
        return this._dbid != null;
    }

    public boolean hasIfIndex() {
        return this._ifIndex != null;
    }

    public boolean hasNodeid() {
        return this._nodeid != null;
    }

    public Iterator<Autoaction> iterateAutoaction() {
        return this._autoactionList.iterator();
    }

    public Iterator<Forward> iterateForward() {
        return this._forwardList.iterator();
    }

    public Iterator<String> iterateLoggroup() {
        return this._loggroupList.iterator();
    }

    public Iterator<Operaction> iterateOperaction() {
        return this._operactionList.iterator();
    }

    public Iterator<Script> iterateScript() {
        return this._scriptList.iterator();
    }

    public void removeAllAutoaction() {
        this._autoactionList.clear();
    }

    public void removeAllForward() {
        this._forwardList.clear();
    }

    public void removeAllLoggroup() {
        this._loggroupList.clear();
    }

    public void removeAllOperaction() {
        this._operactionList.clear();
    }

    public void removeAllScript() {
        this._scriptList.clear();
    }

    public boolean removeAutoaction(Autoaction vAutoaction) {
        return this._autoactionList.remove(vAutoaction);
    }

    public Autoaction removeAutoactionAt(int index) {
        return this._autoactionList.remove(index);
    }

    public boolean removeForward(Forward vForward) {
        return this._forwardList.remove(vForward);
    }

    public Forward removeForwardAt(int index) {
        return this._forwardList.remove(index);
    }

    public boolean removeLoggroup(String vLoggroup) {
        return this._loggroupList.remove(vLoggroup);
    }

    public String removeLoggroupAt(int index) {
        return this._loggroupList.remove(index);
    }

    public boolean removeOperaction(Operaction vOperaction) {
        return this._operactionList.remove(vOperaction);
    }

    public Operaction removeOperactionAt(int index) {
        return this._operactionList.remove(index);
    }

    public boolean removeScript(Script vScript) {
        return this._scriptList.remove(vScript);
    }

    public Script removeScriptAt(int index) {
        return this._scriptList.remove(index);
    }

    public void setAlarmData(AlarmData alarmData) {
        this._alarmData = alarmData;
    }

    public void setAutoacknowledge(Autoacknowledge autoacknowledge) {
        this._autoacknowledge = autoacknowledge;
    }

    public void setAutoaction(int index, Autoaction vAutoaction) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._autoactionList.size()) {
            throw new IndexOutOfBoundsException("setAutoaction: Index value '" + index + "' not in range [0.." + (this._autoactionList.size() - 1) + "]");
        }
        this._autoactionList.set(index, vAutoaction);
    }

    public void setAutoaction(Autoaction[] vAutoactionArray) {
        this._autoactionList.clear();
        for (int i = 0; i < vAutoactionArray.length; ++i) {
            this._autoactionList.add(vAutoactionArray[i]);
        }
    }

    public void setAutoaction(List<Autoaction> vAutoactionList) {
        this._autoactionList.clear();
        this._autoactionList.addAll(vAutoactionList);
    }

    public void setAutoactionCollection(List<Autoaction> autoactionList) {
        this._autoactionList = autoactionList;
    }

    public void setCorrelation(Correlation correlation) {
        this._correlation = correlation;
    }

    public void setCreationTime(Date creationTime) {
        this._creationTime = creationTime;
    }

    public void setDbid(Integer dbid) {
        this._dbid = dbid;
    }

    public void setDescr(String descr) {
        this._descr = descr;
    }

    public void setDistPoller(String distPoller) {
        this._distPoller = distPoller;
    }

    public void setForward(int index, Forward vForward) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._forwardList.size()) {
            throw new IndexOutOfBoundsException("setForward: Index value '" + index + "' not in range [0.." + (this._forwardList.size() - 1) + "]");
        }
        this._forwardList.set(index, vForward);
    }

    public void setForward(Forward[] vForwardArray) {
        this._forwardList.clear();
        for (int i = 0; i < vForwardArray.length; ++i) {
            this._forwardList.add(vForwardArray[i]);
        }
    }

    public void setForward(List<Forward> vForwardList) {
        this._forwardList.clear();
        this._forwardList.addAll(vForwardList);
    }

    public void setForwardCollection(List<Forward> forwardList) {
        this._forwardList = forwardList;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setIfAlias(String ifAlias) {
        this._ifAlias = ifAlias;
    }

    public void setIfIndex(Integer ifIndex) {
        this._ifIndex = ifIndex;
    }

    public void setInterface(String _interface) {
        this._interfaceAddress = InetAddressUtils.addr((String)_interface);
        this._interfaceString = null;
    }

    public void setInterfaceAddress(InetAddress _interface) {
        this._interfaceAddress = _interface;
        this._interfaceString = null;
    }

    public void setLoggroup(int index, String vLoggroup) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._loggroupList.size()) {
            throw new IndexOutOfBoundsException("setLoggroup: Index value '" + index + "' not in range [0.." + (this._loggroupList.size() - 1) + "]");
        }
        this._loggroupList.set(index, vLoggroup);
    }

    public void setLoggroup(String[] vLoggroupArray) {
        this._loggroupList.clear();
        for (int i = 0; i < vLoggroupArray.length; ++i) {
            this._loggroupList.add(vLoggroupArray[i]);
        }
    }

    public void setLoggroup(List<String> vLoggroupList) {
        this._loggroupList.clear();
        this._loggroupList.addAll(vLoggroupList);
    }

    public void setLoggroupCollection(List<String> loggroupList) {
        this._loggroupList = loggroupList;
    }

    public void setLogmsg(Logmsg logmsg) {
        this._logmsg = logmsg;
    }

    public void setMask(Mask mask) {
        this._mask = mask;
    }

    public void setMasterStation(String masterStation) {
        this._masterStation = masterStation;
    }

    public void setMouseovertext(String mouseovertext) {
        this._mouseovertext = mouseovertext;
    }

    public void setNodeid(Long nodeid) {
        this._nodeid = nodeid;
    }

    public void setOperaction(int index, Operaction vOperaction) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._operactionList.size()) {
            throw new IndexOutOfBoundsException("setOperaction: Index value '" + index + "' not in range [0.." + (this._operactionList.size() - 1) + "]");
        }
        this._operactionList.set(index, vOperaction);
    }

    public void setOperaction(Operaction[] vOperactionArray) {
        this._operactionList.clear();
        for (int i = 0; i < vOperactionArray.length; ++i) {
            this._operactionList.add(vOperactionArray[i]);
        }
    }

    public void setOperaction(List<Operaction> vOperactionList) {
        this._operactionList.clear();
        this._operactionList.addAll(vOperactionList);
    }

    public void setOperactionCollection(List<Operaction> operactionList) {
        this._operactionList = operactionList;
    }

    public void setOperinstruct(String operinstruct) {
        this._operinstruct = operinstruct;
    }

    public void setParmCollection(List<Parm> parms) {
        this._parms = parms;
    }

    public void setPathoutage(String pathoutage) {
        this._pathoutage = pathoutage;
    }

    public void setScript(int index, Script vScript) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._scriptList.size()) {
            throw new IndexOutOfBoundsException("setScript: Index value '" + index + "' not in range [0.." + (this._scriptList.size() - 1) + "]");
        }
        this._scriptList.set(index, vScript);
    }

    public void setScript(Script[] vScriptArray) {
        this._scriptList.clear();
        for (int i = 0; i < vScriptArray.length; ++i) {
            this._scriptList.add(vScriptArray[i]);
        }
    }

    public void setScript(List<Script> vScriptList) {
        this._scriptList.clear();
        this._scriptList.addAll(vScriptList);
    }

    public void setScriptCollection(List<Script> scriptList) {
        this._scriptList = scriptList;
    }

    public void setService(String service) {
        this._service = service;
    }

    public void setSeverity(String severity) {
        this._severity = severity;
    }

    public void setSnmp(Snmp snmp) {
        this._snmp = snmp;
    }

    public void setSnmphost(String snmphost) {
        this._snmphost = snmphost;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public void setTime(Date time) {
        this._time = time;
    }

    public void setTticket(Tticket tticket) {
        this._tticket = tticket;
    }

    public void setUei(String uei) {
        this._uei = uei;
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uuid", (Object)this._uuid).append("dbid", (Object)this._dbid).append("dist-poller", (Object)this._distPoller).append("creation-time", (Object)this._creationTime).append("master-station", (Object)this._masterStation).append("mask", (Object)this._mask).append("uei", (Object)this._uei).append("source", (Object)this._source).append("nodeid", (Object)this._nodeid).append("time", (Object)this._time).append("host", (Object)this._host).append("interface", (Object)this.getInterface()).append("snmphost", (Object)this._snmphost).append("service", (Object)this._service).append("snmp", (Object)this._snmp).append("parms", this._parms).append("descr", (Object)this._descr).append("logmsg", (Object)this._logmsg).append("severity", (Object)this._severity).append("pathoutage", (Object)this._pathoutage).append("correlation", (Object)this._correlation).append("operinstruct", (Object)this._operinstruct).append("autoaction", this._autoactionList).append("operaction", this._operactionList).append("autoacknowledge", (Object)this._autoacknowledge).append("loggroup", this._loggroupList).append("tticket", (Object)this._tticket).append("forward", this._forwardList).append("script", this._scriptList).append("ifIndex", (Object)this._ifIndex).append("ifAlias", (Object)this._ifAlias).append("mouseovertext", (Object)this._mouseovertext).append("alarm-data", (Object)this._alarmData).toString();
    }
}

