/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2011-2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

/*
 * This class used to be generated by Castor, but we have converted it to JAXB.
 */

package org.opennms.netmgt.xml.event;

import static org.opennms.core.utils.InetAddressUtils.addr;
import static org.opennms.core.utils.InetAddressUtils.str;

import java.io.Serializable;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.events.api.DateTimeAdapter;

@XmlRootElement(name = "event")
@XmlAccessorType(XmlAccessType.FIELD)
//@ValidateUsing("event.xsd")
public class Event implements Serializable {
        private static final long serialVersionUID = 6997816158234653400L;

	@XmlAttribute(name = "uuid")
	private String _uuid;

	/**
	 * The event database id
	 */
	@XmlElement(name = "dbid")
	private Integer _dbid;

	/**
	 * Field _distPoller.
	 */
	@XmlElement(name = "dist-poller")
	private String _distPoller;

	/**
	 * from header
	 */
	@XmlElement(name = "creation-time")
	@XmlJavaTypeAdapter(DateTimeAdapter.class)
	private Date _creationTime;

	/**
	 * from header
	 */
	@XmlElement(name = "master-station")
	private String _masterStation;

	/**
	 * The event mask which helps to uniquely identify an event
	 */
	@XmlElement(name = "mask")
	private Mask _mask;

	/**
	 * The Universal Event Identifier
	 */
	@XmlElement(name = "uei")
	private String _uei;

	/**
	 * Field _source.
	 */
	@XmlElement(name = "source")
	private String _source;

	/**
	 * The nodeid to which this event pertains
	 */
	@XmlElement(name = "nodeid")
	private Long _nodeid;

	/**
	 * The time at which this event was generated. The time is in the format
	 * generated by the java.text.DateFormat using the DateFormat.FULL style for
	 * the default locale. For example:
	 * "Monday, February 18, 2002 3:01:58 PM EST"
	 */
	@XmlElement(name = "time")
	@XmlJavaTypeAdapter(DateTimeAdapter.class)
	private Date _time;

	/**
	 * The host at which the event is generated
	 */
	@XmlElement(name = "host")
	private String _host;

	/**
	 * The interface to which this event is pertinent
	 */
	@XmlElement(name = "interface")
	@XmlJavaTypeAdapter(InetAddressXmlAdapter.class)
	private InetAddress _interfaceAddress;

	private transient String _interfaceString;
	
	/**
	 * The snmp host of the trap
	 */
	@XmlElement(name = "snmphost")
	private String _snmphost;

	/**
	 * The service to which this event is pertinent
	 */
	@XmlElement(name = "service")
	private String _service;

	/**
	 * The snmp information from the trap
	 */
	@XmlElement(name = "snmp")
	private Snmp _snmp;

	/**
	 * The varbinds from the trap
	 */
	@XmlElementWrapper(name="parms")
	@XmlElement(name="parm")
	private List<Parm> _parms;

	/**
	 * The event description
	 */
	@XmlElement(name = "descr")
	private String _descr;

	/**
	 * The event logmsg
	 */
	@XmlElement(name = "logmsg")
	private Logmsg _logmsg;

	/**
	 * The event severity
	 */
	@XmlElement(name = "severity")
	private String _severity;

	/**
	 * The path outage information
	 */
	@XmlElement(name = "pathoutage")
	private String _pathoutage;

	/**
	 * The event correlation information
	 */
	@XmlElement(name = "correlation")
	private Correlation _correlation;

	/**
	 * The operator instruction for this event
	 */
	@XmlElement(name = "operinstruct")
	private String _operinstruct;

	/**
	 * The automatic action to occur when this event occurs
	 */
	@XmlElement(name = "autoaction")
	private List<Autoaction> _autoactionList;

	/**
	 * The operator action to be taken when this event occurs
	 */
	@XmlElement(name = "operaction")
	private List<Operaction> _operactionList;

	/**
	 * The autoacknowledge information for the user
	 */
	@XmlElement(name = "autoacknowledge")
	private Autoacknowledge _autoacknowledge;

	/**
	 * A logical group with which to associate this event
	 */
	@XmlElement(name = "loggroup")
	private List<String> _loggroupList;

	/**
	 * The trouble ticket info
	 */
	@XmlElement(name = "tticket")
	private Tticket _tticket;

	/**
	 * The forwarding information for this event
	 */
	@XmlElement(name = "forward")
	private List<Forward> _forwardList;

	/**
	 * The script information for this event
	 */
	@XmlElement(name = "script")
	private List<Script> _scriptList;

	/**
	 * The ifIndex to which this event is pertinent
	 */
	@XmlElement(name = "ifIndex")
	private Integer _ifIndex;

	/**
	 * The ifAlias to which this event is pertinent
	 */
	@XmlElement(name = "ifAlias")
	private String _ifAlias;

	/**
	 * The text to be displayed on a 'mouseOver' event when this event is
	 * displayed in the event browser
	 */
	@XmlElement(name = "mouseovertext")
	private String _mouseovertext;

	/**
	 * Data used to create an event.
	 */
	@XmlElement(name = "alarm-data")
	private AlarmData _alarmData;

	// ----------------/
	// - Constructors -/
	// ----------------/

	public Event() {
		super();
		_autoactionList = new ArrayList<Autoaction>();
		_operactionList = new ArrayList<Operaction>();
		_loggroupList = new ArrayList<String>();
		_forwardList = new ArrayList<Forward>();
		_scriptList = new ArrayList<Script>();
	}

	// -----------/
	// - Methods -/
	// -----------/

	/**
	 * 
	 * 
	 * @param vAutoaction
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addAutoaction(final Autoaction vAutoaction)
			throws IndexOutOfBoundsException {
		_autoactionList.add(vAutoaction);
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vAutoaction
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addAutoaction(final int index, final Autoaction vAutoaction) throws IndexOutOfBoundsException {
		_autoactionList.add(index, vAutoaction);
	}

	/**
	 * 
	 * 
	 * @param vForward
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addForward(final Forward vForward) throws IndexOutOfBoundsException {
		_forwardList.add(vForward);
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vForward
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addForward(final int index, final Forward vForward) throws IndexOutOfBoundsException {
		_forwardList.add(index, vForward);
	}

	/**
	 * 
	 * 
	 * @param vLoggroup
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addLoggroup(final String vLoggroup) throws IndexOutOfBoundsException {
		_loggroupList.add(vLoggroup);
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vLoggroup
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addLoggroup(final int index, final String vLoggroup) throws IndexOutOfBoundsException {
		_loggroupList.add(index, vLoggroup);
	}

	/**
	 * 
	 * 
	 * @param vOperaction
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addOperaction(final Operaction vOperaction) throws IndexOutOfBoundsException {
		_operactionList.add(vOperaction);
	}

	public void addParm(final Parm parm) {
	    if (_parms == null) {
	        _parms = new ArrayList<Parm>();
	    }
	    _parms.add(parm);
	}
	
	/**
	 * 
	 * 
	 * @param index
	 * @param vOperaction
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addOperaction(final int index, final Operaction vOperaction) throws IndexOutOfBoundsException {
		_operactionList.add(index, vOperaction);
	}

	/**
	 * 
	 * 
	 * @param vScript
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addScript(final Script vScript) throws IndexOutOfBoundsException {
		_scriptList.add(vScript);
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vScript
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void addScript(final int index, final Script vScript) throws IndexOutOfBoundsException {
		_scriptList.add(index, vScript);
	}

	/**
     */
	public void deleteDbid() {
		_dbid = null;
	}

	/**
     */
	public void deleteIfIndex() {
		_ifIndex = null;
	}

	/**
     */
	public void deleteNodeid() {
		_nodeid = null;
	}

	/**
	 * Method enumerateAutoaction.
	 * 
	 * @return an Enumeration over all possible elements of this collection
	 */
	public Enumeration<Autoaction> enumerateAutoaction() {
		return Collections.enumeration(_autoactionList);
	}

	/**
	 * Method enumerateForward.
	 * 
	 * @return an Enumeration over all possible elements of this collection
	 */
	public Enumeration<Forward> enumerateForward() {
		return Collections.enumeration(_forwardList);
	}

	/**
	 * Method enumerateLoggroup.
	 * 
	 * @return an Enumeration over all possible elements of this collection
	 */
	public Enumeration<String> enumerateLoggroup() {
		return Collections.enumeration(_loggroupList);
	}

	/**
	 * Method enumerateOperaction.
	 * 
	 * @return an Enumeration over all possible elements of this collection
	 */
	public Enumeration<Operaction> enumerateOperaction() {
		return Collections.enumeration(_operactionList);
	}

	/**
	 * Method enumerateScript.
	 * 
	 * @return an Enumeration over all possible elements of this collection
	 */
	public Enumeration<Script> enumerateScript() {
		return Collections.enumeration(_scriptList);
	}

	/**
	 * Returns the value of field 'alarmData'. The field 'alarmData' has the
	 * following description: Data used to create an event.
	 * 
	 * @return the value of field 'AlarmData'.
	 */
	public AlarmData getAlarmData() {
		return _alarmData;
	}

	/**
	 * Returns the value of field 'autoacknowledge'. The field 'autoacknowledge'
	 * has the following description: The autoacknowledge information for the
	 * user
	 * 
	 * @return the value of field 'Autoacknowledge'.
	 */
	public Autoacknowledge getAutoacknowledge() {
		return _autoacknowledge;
	}

	/**
	 * Method getAutoaction.
	 * 
	 * @param index
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 * @return the value of the Autoaction at the
	 *         given index
	 */
	public Autoaction getAutoaction(final int index) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _autoactionList.size()) {
			throw new IndexOutOfBoundsException("getAutoaction: Index value '" + index + "' not in range [0.." + (_autoactionList.size() - 1) + "]");
		}

		return _autoactionList.get(index);
	}

	/**
	 * Method getAutoaction.Returns the contents of the collection in an Array.
	 * <p>
	 * Note: Just in case the collection contents are changing in another
	 * thread, we pass a 0-length Array of the correct type into the API call.
	 * This way we <i>know</i> that the Array returned is of exactly the correct
	 * length.
	 * 
	 * @return this collection as an Array
	 */
	public Autoaction[] getAutoaction() {
		return _autoactionList.toArray(new Autoaction[0]);
	}

	/**
	 * Method getAutoactionCollection.Returns a reference to '_autoactionList'.
	 * No type checking is performed on any modifications to the Vector.
	 * 
	 * @return a reference to the Vector backing this class
	 */
	public List<Autoaction> getAutoactionCollection() {
		return _autoactionList;
	}

	/**
	 * Method getAutoactionCount.
	 * 
	 * @return the size of this collection
	 */
	public int getAutoactionCount() {
		return _autoactionList.size();
	}

	/**
	 * Returns the value of field 'correlation'. The field 'correlation' has the
	 * following description: The event correlation information
	 * 
	 * @return the value of field 'Correlation'.
	 */
	public Correlation getCorrelation() {
		return _correlation;
	}

	/**
	 * Returns the value of field 'creationTime'. The field 'creationTime' has
	 * the following description: from header
	 * 
	 * @return the value of field 'CreationTime'.
	 */
	public Date getCreationTime() {
		return _creationTime;
	}

	/**
	 * Returns the value of field 'dbid'. The field 'dbid' has the following
	 * description: The event database id
	 * 
	 * @return the value of field 'Dbid'.
	 */
	public Integer getDbid() {
		return _dbid == null ? 0 : _dbid;
	}

	/**
	 * Returns the value of field 'descr'. The field 'descr' has the following
	 * description: The event description
	 * 
	 * @return the value of field 'Descr'.
	 */
	public String getDescr() {
		return _descr;
	}

	/**
	 * Returns the value of field 'distPoller'.
	 * 
	 * @return the value of field 'DistPoller'.
	 */
	public String getDistPoller() {
		return _distPoller;
	}

	/**
	 * Method getForward.
	 * 
	 * @param index
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 * @return the value of the Forward at the
	 *         given index
	 */
	public Forward getForward(final int index) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _forwardList.size()) {
			throw new IndexOutOfBoundsException("getForward: Index value '" + index + "' not in range [0.." + (_forwardList.size() - 1) + "]");
		}

		return _forwardList.get(index);
	}

	/**
	 * Method getForward.Returns the contents of the collection in an Array.
	 * <p>
	 * Note: Just in case the collection contents are changing in another
	 * thread, we pass a 0-length Array of the correct type into the API call.
	 * This way we <i>know</i> that the Array returned is of exactly the correct
	 * length.
	 * 
	 * @return this collection as an Array
	 */
	public Forward[] getForward() {
		return _forwardList.toArray(new Forward[0]);
	}

	/**
	 * Method getForwardCollection.Returns a reference to '_forwardList'. No
	 * type checking is performed on any modifications to the Vector.
	 * 
	 * @return a reference to the Vector backing this class
	 */
	public List<Forward> getForwardCollection() {
		return _forwardList;
	}

	/**
	 * Method getForwardCount.
	 * 
	 * @return the size of this collection
	 */
	public int getForwardCount() {
		return _forwardList.size();
	}

	/**
	 * Returns the value of field 'host'. The field 'host' has the following
	 * description: The host at which the event is generated
	 * 
	 * @return the value of field 'Host'.
	 */
	public String getHost() {
		return _host;
	}

	/**
	 * Returns the value of field 'ifAlias'. The field 'ifAlias' has the
	 * following description: The ifAlias to which this event is pertinent
	 * 
	 * @return the value of field 'IfAlias'.
	 */
	public String getIfAlias() {
		return _ifAlias;
	}

	/**
	 * Returns the value of field 'ifIndex'. The field 'ifIndex' has the
	 * following description: The ifIndex to which this event is pertinent
	 * 
	 * @return the value of field 'IfIndex'.
	 */
	public Integer getIfIndex() {
		return _ifIndex == null ? 0 : _ifIndex;
	}

	/**
	 * Returns the value of field 'interface'. The field 'interface' has the
	 * following description: The interface to which this event is pertinent
	 * 
	 * @return the value of field 'Interface'.
	 */
	public String getInterface() {
		if (_interfaceString == null) {
			_interfaceString = str(_interfaceAddress);
		}
		return _interfaceString;
	}

	// just to be sure
	@XmlTransient
	public InetAddress getInterfaceAddress() {
		return _interfaceAddress;
	}

	/**
	 * Method getLoggroup.
	 * 
	 * @param index
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 * @return the value of the String at the given index
	 */
	public String getLoggroup(final int index) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _loggroupList.size()) {
			throw new IndexOutOfBoundsException("getLoggroup: Index value '" + index + "' not in range [0.." + (_loggroupList.size() - 1) + "]");
		}

		return _loggroupList.get(index);
	}

	/**
	 * Method getLoggroup.Returns the contents of the collection in an Array.
	 * <p>
	 * Note: Just in case the collection contents are changing in another
	 * thread, we pass a 0-length Array of the correct type into the API call.
	 * This way we <i>know</i> that the Array returned is of exactly the correct
	 * length.
	 * 
	 * @return this collection as an Array
	 */
	public String[] getLoggroup() {
		return _loggroupList.toArray(new String[0]);
	}

	/**
	 * Method getLoggroupCollection.Returns a reference to '_loggroupList'. No
	 * type checking is performed on any modifications to the Vector.
	 * 
	 * @return a reference to the Vector backing this class
	 */
	public List<String> getLoggroupCollection() {
		return _loggroupList;
	}

	/**
	 * Method getLoggroupCount.
	 * 
	 * @return the size of this collection
	 */
	public int getLoggroupCount() {
		return _loggroupList.size();
	}

	/**
	 * Returns the value of field 'logmsg'. The field 'logmsg' has the following
	 * description: The event logmsg
	 * 
	 * @return the value of field 'Logmsg'.
	 */
	public Logmsg getLogmsg() {
		return _logmsg;
	}

	/**
	 * Returns the value of field 'mask'. The field 'mask' has the following
	 * description: The event mask which helps to uniquely identify an event
	 * 
	 * @return the value of field 'Mask'.
	 */
	public Mask getMask() {
		return _mask;
	}

	/**
	 * Returns the value of field 'masterStation'. The field 'masterStation' has
	 * the following description: from header
	 * 
	 * @return the value of field 'MasterStation'.
	 */
	public String getMasterStation() {
		return _masterStation;
	}

	/**
	 * Returns the value of field 'mouseovertext'. The field 'mouseovertext' has
	 * the following description: The text to be displayed on a 'mouseOver'
	 * event when this event is displayed in the event browser
	 * 
	 * @return the value of field 'Mouseovertext'.
	 */
	public String getMouseovertext() {
		return _mouseovertext;
	}

	/**
	 * Returns the value of field 'nodeid'. The field 'nodeid' has the following
	 * description: The nodeid to which this event pertains
	 * 
	 * @return the value of field 'Nodeid'.
	 */
	public Long getNodeid() {
		return _nodeid == null ? 0 : _nodeid;
	}

	/**
	 * Method getOperaction.
	 * 
	 * @param index
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 * @return the value of the Operaction at the
	 *         given index
	 */
	public Operaction getOperaction(final int index) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _operactionList.size()) {
			throw new IndexOutOfBoundsException("getOperaction: Index value '" + index + "' not in range [0.." + (_operactionList.size() - 1) + "]");
		}

		return _operactionList.get(index);
	}

	/**
	 * Method getOperaction.Returns the contents of the collection in an Array.
	 * <p>
	 * Note: Just in case the collection contents are changing in another
	 * thread, we pass a 0-length Array of the correct type into the API call.
	 * This way we <i>know</i> that the Array returned is of exactly the correct
	 * length.
	 * 
	 * @return this collection as an Array
	 */
	public Operaction[] getOperaction() {
		return (Operaction[]) _operactionList.toArray(new Operaction[0]);
	}

	/**
	 * Method getOperactionCollection.Returns a reference to '_operactionList'.
	 * No type checking is performed on any modifications to the Vector.
	 * 
	 * @return a reference to the Vector backing this class
	 */
	public List<Operaction> getOperactionCollection() {
		return _operactionList;
	}

	/**
	 * Method getOperactionCount.
	 * 
	 * @return the size of this collection
	 */
	public int getOperactionCount() {
		return _operactionList.size();
	}

	/**
	 * Returns the value of field 'operinstruct'. The field 'operinstruct' has
	 * the following description: The operator instruction for this event
	 * 
	 * @return the value of field 'Operinstruct'.
	 */
	public String getOperinstruct() {
		return _operinstruct;
	}

	/**
	 * Returns the Collection of parms for this event
	 */
    public List<Parm> getParmCollection() {
        return _parms == null ? Collections.<Parm>emptyList() : _parms;
    }

    public Parm getParm(final String key) {
        if (_parms == null) {
            return null;
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key cannot be null!");
        }

        for (final Parm parm : _parms) {
            if (key.equals(parm.getParmName())) {
                return parm;
            }
        }

        return null;
    }

	/**
	 * Returns the value of field 'pathoutage'. The field 'pathoutage' has the
	 * following description: The path outage information
	 * 
	 * @return the value of field 'Pathoutage'.
	 */
	public String getPathoutage() {
		return _pathoutage;
	}

	/**
	 * Method getScript.
	 * 
	 * @param index
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 * @return the value of the Script at the given index
	 */
	public Script getScript(final int index) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _scriptList.size()) {
			throw new IndexOutOfBoundsException("getScript: Index value '" + index + "' not in range [0.." + (_scriptList.size() - 1) + "]");
		}

		return _scriptList.get(index);
	}

	/**
	 * Method getScript.Returns the contents of the collection in an Array.
	 * <p>
	 * Note: Just in case the collection contents are changing in another
	 * thread, we pass a 0-length Array of the correct type into the API call.
	 * This way we <i>know</i> that the Array returned is of exactly the correct
	 * length.
	 * 
	 * @return this collection as an Array
	 */
	public Script[] getScript() {
		return _scriptList.toArray(new Script[0]);
	}

	/**
	 * Method getScriptCollection.Returns a reference to '_scriptList'. No type
	 * checking is performed on any modifications to the Vector.
	 * 
	 * @return a reference to the Vector backing this class
	 */
	public List<Script> getScriptCollection() {
		return _scriptList;
	}

	/**
	 * Method getScriptCount.
	 * 
	 * @return the size of this collection
	 */
	public int getScriptCount() {
		return _scriptList.size();
	}

	/**
	 * Returns the value of field 'service'. The field 'service' has the
	 * following description: The service to which this event is pertinent
	 * 
	 * @return the value of field 'Service'.
	 */
	public String getService() {
		return _service;
	}

	/**
	 * Returns the value of field 'severity'. The field 'severity' has the
	 * following description: The event severity
	 * 
	 * @return the value of field 'Severity'.
	 */
	public String getSeverity() {
		return _severity;
	}

	/**
	 * Returns the value of field 'snmp'. The field 'snmp' has the following
	 * description: The snmp information from the trap
	 * 
	 * @return the value of field 'Snmp'.
	 */
	public Snmp getSnmp() {
		return _snmp;
	}

	/**
	 * Returns the value of field 'snmphost'. The field 'snmphost' has the
	 * following description: The snmp host of the trap
	 * 
	 * @return the value of field 'Snmphost'.
	 */
	public String getSnmphost() {
		return _snmphost;
	}

	/**
	 * Returns the value of field 'source'.
	 * 
	 * @return the value of field 'Source'.
	 */
	public String getSource() {
		return _source;
	}

	/**
	 * Returns the value of field 'time'. The field 'time' has the following
	 * description: The time at which this event was generated. The time is in
	 * the format generated by the {@link java.text.DateFormat} using the
	 * {@link DateFormat#FULL} style for the default locale. For example:
	 * "Monday, February 18, 2002 3:01:58 PM EST"
	 * 
	 * Known Issues: This field doesn't have millisecond resolution because we
	 * are using {@link DateFormat#FULL}.
	 * 
	 * @see http://issues.opennms.org/browse/NMS-3561
	 * 
	 * @return the value of field 'Time'.
	 */
	public Date getTime() {
		return _time;
	}

	/**
	 * Returns the value of field 'tticket'. The field 'tticket' has the
	 * following description: The trouble ticket info
	 * 
	 * @return the value of field 'Tticket'.
	 */
	public Tticket getTticket() {
		return _tticket;
	}

	/**
	 * Returns the value of field 'uei'. The field 'uei' has the following
	 * description: The Universal Event Identifier
	 * 
	 * @return the value of field 'Uei'.
	 */
	public String getUei() {
		return _uei;
	}

	/**
	 * Returns the value of field 'uuid'.
	 * 
	 * @return the value of field 'Uuid'.
	 */
	public String getUuid() {
		return _uuid;
	}

	/**
	 * Method hasDbid.
	 * 
	 * @return true if at least one Dbid has been added
	 */
	public boolean hasDbid() {
		return _dbid != null;
	}

	/**
	 * Method hasIfIndex.
	 * 
	 * @return true if at least one IfIndex has been added
	 */
	public boolean hasIfIndex() {
		return _ifIndex != null;
	}

	/**
	 * Method hasNodeid.
	 * 
	 * @return true if at least one Nodeid has been added
	 */
	public boolean hasNodeid() {
		return _nodeid != null;
	}

	/**
	 * Method iterateAutoaction.
	 * 
	 * @return an Iterator over all possible elements in this collection
	 */
	public Iterator<Autoaction> iterateAutoaction() {
		return _autoactionList.iterator();
	}

	/**
	 * Method iterateForward.
	 * 
	 * @return an Iterator over all possible elements in this collection
	 */
	public Iterator<Forward> iterateForward() {
		return _forwardList.iterator();
	}

	/**
	 * Method iterateLoggroup.
	 * 
	 * @return an Iterator over all possible elements in this collection
	 */
	public Iterator<String> iterateLoggroup() {
		return _loggroupList.iterator();
	}

	/**
	 * Method iterateOperaction.
	 * 
	 * @return an Iterator over all possible elements in this collection
	 */
	public Iterator<Operaction> iterateOperaction() {
		return _operactionList.iterator();
	}

	/**
	 * Method iterateScript.
	 * 
	 * @return an Iterator over all possible elements in this collection
	 */
	public Iterator<Script> iterateScript() {
		return _scriptList.iterator();
	}

	/**
     */
	public void removeAllAutoaction() {
		_autoactionList.clear();
	}

	/**
     */
	public void removeAllForward() {
		_forwardList.clear();
	}

	/**
     */
	public void removeAllLoggroup() {
		_loggroupList.clear();
	}

	/**
     */
	public void removeAllOperaction() {
		_operactionList.clear();
	}

	/**
     */
	public void removeAllScript() {
		_scriptList.clear();
	}

	/**
	 * Method removeAutoaction.
	 * 
	 * @param vAutoaction
	 * @return true if the object was removed from the collection.
	 */
	public boolean removeAutoaction(final Autoaction vAutoaction) {
		return _autoactionList.remove(vAutoaction);
	}

	/**
	 * Method removeAutoactionAt.
	 * 
	 * @param index
	 * @return the element removed from the collection
	 */
	public Autoaction removeAutoactionAt(final int index) {
		return _autoactionList.remove(index);
	}

	/**
	 * Method removeForward.
	 * 
	 * @param vForward
	 * @return true if the object was removed from the collection.
	 */
	public boolean removeForward(final Forward vForward) {
		return _forwardList.remove(vForward);
	}

	/**
	 * Method removeForwardAt.
	 * 
	 * @param index
	 * @return the element removed from the collection
	 */
	public Forward removeForwardAt(final int index) {
		return _forwardList.remove(index);
	}

	/**
	 * Method removeLoggroup.
	 * 
	 * @param vLoggroup
	 * @return true if the object was removed from the collection.
	 */
	public boolean removeLoggroup(final String vLoggroup) {
		return _loggroupList.remove(vLoggroup);
	}

	/**
	 * Method removeLoggroupAt.
	 * 
	 * @param index
	 * @return the element removed from the collection
	 */
	public String removeLoggroupAt(final int index) {
		return _loggroupList.remove(index);
	}

	/**
	 * Method removeOperaction.
	 * 
	 * @param vOperaction
	 * @return true if the object was removed from the collection.
	 */
	public boolean removeOperaction(final Operaction vOperaction) {
		return _operactionList.remove(vOperaction);
	}

	/**
	 * Method removeOperactionAt.
	 * 
	 * @param index
	 * @return the element removed from the collection
	 */
	public Operaction removeOperactionAt(final int index) {
		return _operactionList.remove(index);
	}

	/**
	 * Method removeScript.
	 * 
	 * @param vScript
	 * @return true if the object was removed from the collection.
	 */
	public boolean removeScript(final Script vScript) {
		return _scriptList.remove(vScript);
	}

	/**
	 * Method removeScriptAt.
	 * 
	 * @param index
	 * @return the element removed from the collection
	 */
	public Script removeScriptAt(final int index) {
		return _scriptList.remove(index);
	}

	/**
	 * Sets the value of field 'alarmData'. The field 'alarmData' has the
	 * following description: Data used to create an event.
	 * 
	 * @param alarmData
	 *            the value of field 'alarmData'.
	 */
	public void setAlarmData(final AlarmData alarmData) {
		_alarmData = alarmData;
	}

	/**
	 * Sets the value of field 'autoacknowledge'. The field 'autoacknowledge'
	 * has the following description: The autoacknowledge information for the
	 * user
	 * 
	 * @param autoacknowledge
	 *            the value of field 'autoacknowledge'.
	 */
	public void setAutoacknowledge(final Autoacknowledge autoacknowledge) {
		_autoacknowledge = autoacknowledge;
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vAutoaction
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void setAutoaction(final int index, final Autoaction vAutoaction) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _autoactionList.size()) {
			throw new IndexOutOfBoundsException("setAutoaction: Index value '" + index + "' not in range [0.." + (_autoactionList.size() - 1) + "]");
		}

		_autoactionList.set(index, vAutoaction);
	}

	/**
	 * 
	 * 
	 * @param vAutoactionArray
	 */
	public void setAutoaction(final Autoaction[] vAutoactionArray) {
		// -- copy array
		_autoactionList.clear();

		for (int i = 0; i < vAutoactionArray.length; i++) {
			_autoactionList.add(vAutoactionArray[i]);
		}
	}

	/**
	 * Sets the value of '_autoactionList' by copying the given Vector. All
	 * elements will be checked for type safety.
	 * 
	 * @param vAutoactionList
	 *            the Vector to copy.
	 */
	public void setAutoaction(final List<Autoaction> vAutoactionList) {
		// copy vector
		_autoactionList.clear();

		_autoactionList.addAll(vAutoactionList);
	}

	/**
	 * Sets the value of '_autoactionList' by setting it to the given Vector. No
	 * type checking is performed.
	 * 
	 * @deprecated
	 * 
	 * @param autoactionList
	 *            the Vector to set.
	 */
	public void setAutoactionCollection(final List<Autoaction> autoactionList) {
		_autoactionList = autoactionList;
	}

	/**
	 * Sets the value of field 'correlation'. The field 'correlation' has the
	 * following description: The event correlation information
	 * 
	 * @param correlation
	 *            the value of field 'correlation'.
	 */
	public void setCorrelation(final Correlation correlation) {
		_correlation = correlation;
	}

	/**
	 * Sets the value of field 'creationTime'. The field 'creationTime' has the
	 * following description: from header
	 * 
	 * @param creationTime
	 *            the value of field 'creationTime'.
	 */
	public void setCreationTime(final Date creationTime) {
		_creationTime = creationTime;
	}

	/**
	 * Sets the value of field 'dbid'. The field 'dbid' has the following
	 * description: The event database id
	 * 
	 * @param dbid
	 *            the value of field 'dbid'.
	 */
	public void setDbid(final Integer dbid) {
		_dbid = dbid;
	}

	/**
	 * Sets the value of field 'descr'. The field 'descr' has the following
	 * description: The event description
	 * 
	 * @param descr
	 *            the value of field 'descr'.
	 */
	public void setDescr(final String descr) {
		_descr = descr;
	}

	/**
	 * Sets the value of field 'distPoller'.
	 * 
	 * @param distPoller
	 *            the value of field 'distPoller'.
	 */
	public void setDistPoller(final String distPoller) {
		_distPoller = distPoller;
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vForward
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void setForward(final int index, final Forward vForward) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _forwardList.size()) {
			throw new IndexOutOfBoundsException("setForward: Index value '" + index + "' not in range [0.." + (_forwardList.size() - 1) + "]");
		}

		_forwardList.set(index, vForward);
	}

	/**
	 * 
	 * 
	 * @param vForwardArray
	 */
	public void setForward(final Forward[] vForwardArray) {
		// -- copy array
		_forwardList.clear();

		for (int i = 0; i < vForwardArray.length; i++) {
			_forwardList.add(vForwardArray[i]);
		}
	}

	/**
	 * Sets the value of '_forwardList' by copying the given Vector. All
	 * elements will be checked for type safety.
	 * 
	 * @param vForwardList
	 *            the Vector to copy.
	 */
	public void setForward(final List<Forward> vForwardList) {
		// copy vector
		_forwardList.clear();

		_forwardList.addAll(vForwardList);
	}

	/**
	 * Sets the value of '_forwardList' by setting it to the given Vector. No
	 * type checking is performed.
	 * 
	 * @deprecated
	 * 
	 * @param forwardList
	 *            the Vector to set.
	 */
	public void setForwardCollection(final List<Forward> forwardList) {
		_forwardList = forwardList;
	}

	/**
	 * Sets the value of field 'host'. The field 'host' has the following
	 * description: The host at which the event is generated
	 * 
	 * @param host
	 *            the value of field 'host'.
	 */
	public void setHost(final String host) {
		_host = host;
	}

	/**
	 * Sets the value of field 'ifAlias'. The field 'ifAlias' has the following
	 * description: The ifAlias to which this event is pertinent
	 * 
	 * @param ifAlias
	 *            the value of field 'ifAlias'.
	 */
	public void setIfAlias(final String ifAlias) {
		_ifAlias = ifAlias;
	}

	/**
	 * Sets the value of field 'ifIndex'. The field 'ifIndex' has the following
	 * description: The ifIndex to which this event is pertinent
	 * 
	 * @param ifIndex
	 *            the value of field 'ifIndex'.
	 */
	public void setIfIndex(final Integer ifIndex) {
		_ifIndex = ifIndex;
	}

	/**
	 * The interface to which this event is pertinent
	 */
	public void setInterface(final String _interface) {
		_interfaceAddress = addr(_interface);
		_interfaceString = null;
	}

	public void setInterfaceAddress(final InetAddress _interface) {
		_interfaceAddress = _interface;
		_interfaceString = null;
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vLoggroup
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void setLoggroup(final int index, final String vLoggroup) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _loggroupList.size()) {
			throw new IndexOutOfBoundsException("setLoggroup: Index value '" + index + "' not in range [0.." + (_loggroupList.size() - 1) + "]");
		}

		_loggroupList.set(index, vLoggroup);
	}

	/**
	 * 
	 * 
	 * @param vLoggroupArray
	 */
	public void setLoggroup(final String[] vLoggroupArray) {
		// -- copy array
		_loggroupList.clear();

		for (int i = 0; i < vLoggroupArray.length; i++) {
			_loggroupList.add(vLoggroupArray[i]);
		}
	}

	/**
	 * Sets the value of '_loggroupList' by copying the given Vector. All
	 * elements will be checked for type safety.
	 * 
	 * @param vLoggroupList
	 *            the Vector to copy.
	 */
	public void setLoggroup(final List<String> vLoggroupList) {
		// copy vector
		_loggroupList.clear();

		_loggroupList.addAll(vLoggroupList);
	}

	/**
	 * Sets the value of '_loggroupList' by setting it to the given Vector. No
	 * type checking is performed.
	 * 
	 * @deprecated
	 * 
	 * @param loggroupList
	 *            the Vector to set.
	 */
	public void setLoggroupCollection(final List<String> loggroupList) {
		_loggroupList = loggroupList;
	}

	/**
	 * Sets the value of field 'logmsg'. The field 'logmsg' has the following
	 * description: The event logmsg
	 * 
	 * @param logmsg
	 *            the value of field 'logmsg'.
	 */
	public void setLogmsg(final Logmsg logmsg) {
		_logmsg = logmsg;
	}

	/**
	 * Sets the value of field 'mask'. The field 'mask' has the following
	 * description: The event mask which helps to uniquely identify an event
	 * 
	 * @param mask
	 *            the value of field 'mask'.
	 */
	public void setMask(final Mask mask) {
		_mask = mask;
	}

	/**
	 * Sets the value of field 'masterStation'. The field 'masterStation' has
	 * the following description: from header
	 * 
	 * @param masterStation
	 *            the value of field 'masterStation'.
	 */
	public void setMasterStation(final String masterStation) {
		_masterStation = masterStation;
	}

	/**
	 * Sets the value of field 'mouseovertext'. The field 'mouseovertext' has
	 * the following description: The text to be displayed on a 'mouseOver'
	 * event when this event is displayed in the event browser
	 * 
	 * @param mouseovertext
	 *            the value of field 'mouseovertext'.
	 */
	public void setMouseovertext(final String mouseovertext) {
		_mouseovertext = mouseovertext;
	}

	/**
	 * Sets the value of field 'nodeid'. The field 'nodeid' has the following
	 * description: The nodeid to which this event pertains
	 * 
	 * @param nodeid
	 *            the value of field 'nodeid'.
	 */
	public void setNodeid(final Long nodeid) {
		_nodeid = nodeid;
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vOperaction
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void setOperaction(final int index, final Operaction vOperaction) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _operactionList.size()) {
			throw new IndexOutOfBoundsException("setOperaction: Index value '" + index + "' not in range [0.." + (_operactionList.size() - 1) + "]");
		}

		_operactionList.set(index, vOperaction);
	}

	/**
	 * 
	 * 
	 * @param vOperactionArray
	 */
	public void setOperaction(final Operaction[] vOperactionArray) {
		// -- copy array
		_operactionList.clear();

		for (int i = 0; i < vOperactionArray.length; i++) {
			_operactionList.add(vOperactionArray[i]);
		}
	}

	/**
	 * Sets the value of '_operactionList' by copying the given Vector. All
	 * elements will be checked for type safety.
	 * 
	 * @param vOperactionList
	 *            the Vector to copy.
	 */
	public void setOperaction(final List<Operaction> vOperactionList) {
		// copy vector
		_operactionList.clear();

		_operactionList.addAll(vOperactionList);
	}

	/**
	 * Sets the value of '_operactionList' by setting it to the given Vector. No
	 * type checking is performed.
	 * 
	 * @deprecated
	 * 
	 * @param operactionList
	 *            the Vector to set.
	 */
	public void setOperactionCollection(final List<Operaction> operactionList) {
		_operactionList = operactionList;
	}

	/**
	 * Sets the value of field 'operinstruct'. The field 'operinstruct' has the
	 * following description: The operator instruction for this event
	 * 
	 * @param operinstruct
	 *            the value of field 'operinstruct'.
	 */
	public void setOperinstruct(final String operinstruct) {
		_operinstruct = operinstruct;
	}

	public void setParmCollection(final List<Parm> parms) {
	    _parms = parms;
	}

	/**
	 * Sets the value of field 'pathoutage'. The field 'pathoutage' has the
	 * following description: The path outage information
	 * 
	 * @param pathoutage
	 *            the value of field 'pathoutage'.
	 */
	public void setPathoutage(final String pathoutage) {
		_pathoutage = pathoutage;
	}

	/**
	 * 
	 * 
	 * @param index
	 * @param vScript
	 * @throws IndexOutOfBoundsException
	 *             if the index given is outside the bounds of the collection
	 */
	public void setScript(final int index, final Script vScript) throws IndexOutOfBoundsException {
		// check bounds for index
		if (index < 0 || index >= _scriptList.size()) {
			throw new IndexOutOfBoundsException("setScript: Index value '" + index + "' not in range [0.." + (_scriptList.size() - 1) + "]");
		}

		_scriptList.set(index, vScript);
	}

	/**
	 * 
	 * 
	 * @param vScriptArray
	 */
	public void setScript(final Script[] vScriptArray) {
		// -- copy array
		_scriptList.clear();

		for (int i = 0; i < vScriptArray.length; i++) {
			_scriptList.add(vScriptArray[i]);
		}
	}

	/**
	 * Sets the value of '_scriptList' by copying the given Vector. All elements
	 * will be checked for type safety.
	 * 
	 * @param vScriptList
	 *            the Vector to copy.
	 */
	public void setScript(final List<Script> vScriptList) {
		// copy vector
		_scriptList.clear();

		_scriptList.addAll(vScriptList);
	}

	/**
	 * Sets the value of '_scriptList' by setting it to the given Vector. No
	 * type checking is performed.
	 * 
	 * @deprecated
	 * 
	 * @param scriptList
	 *            the Vector to set.
	 */
	public void setScriptCollection(final List<Script> scriptList) {
		_scriptList = scriptList;
	}

	/**
	 * Sets the value of field 'service'. The field 'service' has the following
	 * description: The service to which this event is pertinent
	 * 
	 * @param service
	 *            the value of field 'service'.
	 */
	public void setService(final String service) {
		_service = service;
	}

	/**
	 * Sets the value of field 'severity'. The field 'severity' has the
	 * following description: The event severity
	 * 
	 * @param severity
	 *            the value of field 'severity'.
	 */
	public void setSeverity(final String severity) {
		_severity = severity;
	}

	/**
	 * Sets the value of field 'snmp'. The field 'snmp' has the following
	 * description: The snmp information from the trap
	 * 
	 * @param snmp
	 *            the value of field 'snmp'.
	 */
	public void setSnmp(final Snmp snmp) {
		_snmp = snmp;
	}

	/**
	 * Sets the value of field 'snmphost'. The field 'snmphost' has the
	 * following description: The snmp host of the trap
	 * 
	 * @param snmphost
	 *            the value of field 'snmphost'.
	 */
	public void setSnmphost(final String snmphost) {
		_snmphost = snmphost;
	}

	/**
	 * Sets the value of field 'source'.
	 * 
	 * @param source
	 *            the value of field 'source'.
	 */
	public void setSource(final String source) {
		_source = source;
	}

	/**
	 * Sets the value of field 'time'. The field 'time' has the following
	 * description: The time at which this event was generated. The time is in
	 * the format generated by the java.text.DateFormat using the
	 * DateFormat.FULL style for the default locale. For example:
	 * "Monday, February 18, 2002 3:01:58 PM EST"
	 * 
	 * @param time
	 *            the value of field 'time'.
	 */
	public void setTime(final Date time) {
		_time = time;
	}

	/**
	 * Sets the value of field 'tticket'. The field 'tticket' has the following
	 * description: The trouble ticket info
	 * 
	 * @param tticket
	 *            the value of field 'tticket'.
	 */
	public void setTticket(final Tticket tticket) {
		_tticket = tticket;
	}

	/**
	 * Sets the value of field 'uei'. The field 'uei' has the following
	 * description: The Universal Event Identifier
	 * 
	 * @param uei
	 *            the value of field 'uei'.
	 */
	public void setUei(final String uei) {
		_uei = uei;
	}

	/**
	 * Sets the value of field 'uuid'.
	 * 
	 * @param uuid
	 *            the value of field 'uuid'.
	 */
	public void setUuid(final String uuid) {
		_uuid = uuid;
	}

    @Override
	public String toString() {
		return new ToStringBuilder(this)
			.append("uuid", _uuid)
			.append("dbid", _dbid)
			.append("dist-poller", _distPoller)
			.append("creation-time", _creationTime)
			.append("master-station", _masterStation)
			.append("mask", _mask)
			.append("uei", _uei)
			.append("source", _source)
			.append("nodeid", _nodeid)
			.append("time", _time)
			.append("host", _host)
			.append("interface", getInterface())
			.append("snmphost", _snmphost)
			.append("service", _service)
			.append("snmp", _snmp)
			.append("parms", _parms)
			.append("descr", _descr)
			.append("logmsg", _logmsg)
			.append("severity", _severity)
			.append("pathoutage", _pathoutage)
			.append("correlation", _correlation)
			.append("operinstruct", _operinstruct)
			.append("autoaction", _autoactionList)
			.append("operaction", _operactionList)
			.append("autoacknowledge", _autoacknowledge)
			.append("loggroup", _loggroupList)
			.append("tticket", _tticket)
			.append("forward", _forwardList)
			.append("script", _scriptList)
			.append("ifIndex", _ifIndex)
			.append("ifAlias", _ifAlias)
			.append("mouseovertext", _mouseovertext)
			.append("alarm-data", _alarmData)
			.toString();
	}

}
