/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.enlinkd.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.TopologyPersister;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;

@Command(scope="enlinkd", name="generate-topology", description="Creates a linkd topology")
@Service
public class GenerateTopologyCommand
implements Action {
    @Option(name="--nodes", description="generate <N> OmnsNodes. Default: 10")
    private Integer amountNodes;
    @Option(name="--elements", description="generate <N> (Cdp | IsIs | Lldp | Ospf ) Elements, depending on protocol. Default: amount nodes.")
    private Integer amountElements;
    @Option(name="--links", description="generate <N> (Cdp | IsIs | Lldp | Ospf ) Links, depending on protocol. Default: amount elements.")
    private Integer amountLinks;
    @Option(name="--snmpinterfaces", description="generate <N> SnmpInterfaces but not more than amount nodes. Default: amount nodes * 18.")
    private Integer amountSnmpInterfaces;
    @Option(name="--ipinterfaces", description="generate <N> IpInterfaces but not more than amount snmp interfaces. Default: amount nodes * 2.")
    private Integer amountIpInterfaces;
    @Option(name="--topology", description="type of topology (complete | ring | random). Default: random.")
    private String topology;
    @Option(name="--protocol", description="type of protocol (cdp | isis | lldp | ospf). Default: cdp.")
    private String protocol;
    @Reference
    private GenericPersistenceAccessor genericPersistenceAccessor;

    public Object execute() {
        TopologyGenerator.ProgressCallback progressCallback = new TopologyGenerator.ProgressCallback(System.out::println);
        TopologyGenerator generator = TopologyGenerator.builder().persister(new TopologyPersister(this.genericPersistenceAccessor, progressCallback)).progressCallback(progressCallback).build();
        TopologySettings settings = TopologySettings.builder().amountElements(this.amountElements).amountIpInterfaces(this.amountIpInterfaces).amountLinks(this.amountLinks).amountNodes(this.amountNodes).amountSnmpInterfaces(this.amountSnmpInterfaces).protocol(this.toEnumOrNull(TopologyGenerator.Protocol.class, this.protocol)).topology(this.toEnumOrNull(TopologyGenerator.Topology.class, this.topology)).build();
        generator.generateTopology(settings);
        return null;
    }

    private <E extends Enum> E toEnumOrNull(Class<E> enumClass, String s) {
        return s == null ? null : (E)Enum.valueOf(enumClass, s);
    }
}

