/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;
import org.opennms.netmgt.enlinkd.service.api.IpNetToMediaTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class IpNetToMediaTopologyServiceImpl
implements IpNetToMediaTopologyService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private static final Logger LOG = LoggerFactory.getLogger(IpNetToMediaTopologyServiceImpl.class);
    private IpNetToMediaDao m_ipNetToMediaDao;
    private IpInterfaceDao m_ipInterfaceDao;

    public void delete(int nodeid) {
        this.m_ipNetToMediaDao.deleteBySourceNodeId(Integer.valueOf(nodeid));
        this.m_ipNetToMediaDao.flush();
    }

    public void reconcile(int nodeId, Date now) {
        this.m_ipNetToMediaDao.deleteBySourceNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ipNetToMediaDao.flush();
    }

    public void store(int nodeId, IpNetToMedia ipnettomedia) {
        if (ipnettomedia == null) {
            return;
        }
        this.saveIpNetToMedia(nodeId, ipnettomedia);
    }

    @Transactional
    protected void saveIpNetToMedia(final int nodeId, final IpNetToMedia saveMe) {
        new UpsertTemplate<IpNetToMedia, IpNetToMediaDao>(this.m_transactionManager, this.m_ipNetToMediaDao){

            protected IpNetToMedia query() {
                return ((IpNetToMediaDao)this.m_dao).getByNetAndPhysAddress(saveMe.getNetAddress(), saveMe.getPhysAddress());
            }

            protected IpNetToMedia doUpdate(IpNetToMedia dbIpNetToMedia) {
                OnmsNode sourceNode = new OnmsNode();
                sourceNode.setId(Integer.valueOf(nodeId));
                saveMe.setSourceNode(sourceNode);
                IpNetToMediaTopologyServiceImpl.this.putOnmsPropertyForIpNetToMedia(saveMe);
                dbIpNetToMedia.merge(saveMe);
                ((IpNetToMediaDao)this.m_dao).update((Object)dbIpNetToMedia);
                ((IpNetToMediaDao)this.m_dao).flush();
                return dbIpNetToMedia;
            }

            protected IpNetToMedia doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setSourceNode(node);
                IpNetToMediaTopologyServiceImpl.this.putOnmsPropertyForIpNetToMedia(saveMe);
                saveMe.setLastPollTime(saveMe.getCreateTime());
                ((IpNetToMediaDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((IpNetToMediaDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    private void putOnmsPropertyForIpNetToMedia(IpNetToMedia ipnetToMedia) {
        List onmsiplist = this.m_ipInterfaceDao.findByIpAddress(InetAddressUtils.str((InetAddress)ipnetToMedia.getNetAddress()));
        if (onmsiplist.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No OnmsIpInterface found for {}", (Object)ipnetToMedia);
            }
            return;
        }
        if (onmsiplist.size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} OnmsIpInterface for {}", (Object)onmsiplist.size(), (Object)ipnetToMedia);
            }
            List nodeids = onmsiplist.stream().map(onmsip -> onmsip.getNodeId()).collect(Collectors.toList());
            ipnetToMedia.setPort("Multiple Nodes: " + nodeids);
            return;
        }
        OnmsIpInterface onmsip2 = (OnmsIpInterface)onmsiplist.iterator().next();
        ipnetToMedia.setNode(onmsip2.getNode());
        if (onmsip2.getSnmpInterface() == null) {
            ipnetToMedia.setIfIndex(Integer.valueOf(-1));
            return;
        }
        ipnetToMedia.setIfIndex(onmsip2.getIfIndex());
        ipnetToMedia.setPort(Topology.getPortTextString((SnmpInterfaceTopologyEntity)SnmpInterfaceTopologyEntity.create((OnmsSnmpInterface)onmsip2.getSnmpInterface())));
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }
}

