/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeElement;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.model.BridgeStpLink;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeMacLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeStpLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;
import org.opennms.netmgt.enlinkd.service.api.Bridge;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgePortWithMacs;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.BroadcastDomain;
import org.opennms.netmgt.enlinkd.service.api.MacPort;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyShared;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class BridgeTopologyServiceImpl
extends TopologyServiceImpl
implements BridgeTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(BridgeTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private BridgeElementDao m_bridgeElementDao;
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    private BridgeStpLinkDao m_bridgeStpLinkDao;
    private IpNetToMediaDao m_ipNetToMediaDao;
    volatile Map<Integer, Set<BridgeForwardingTableEntry>> m_nodetoBroadcastDomainMap = new HashMap<Integer, Set<BridgeForwardingTableEntry>>();
    volatile Set<BroadcastDomain> m_domains;
    private volatile Set<Integer> m_bridgecollectionsscheduled = new HashSet<Integer>();

    public BridgeElementDao getBridgeElementDao() {
        return this.m_bridgeElementDao;
    }

    public void setBridgeElementDao(BridgeElementDao bridgeElementDao) {
        this.m_bridgeElementDao = bridgeElementDao;
    }

    public BridgeBridgeLinkDao getBridgeBridgeLinkDao() {
        return this.m_bridgeBridgeLinkDao;
    }

    public void setBridgeBridgeLinkDao(BridgeBridgeLinkDao bridgeBridgeLinkDao) {
        this.m_bridgeBridgeLinkDao = bridgeBridgeLinkDao;
    }

    public BridgeMacLinkDao getBridgeMacLinkDao() {
        return this.m_bridgeMacLinkDao;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMacLinkDao = bridgeMacLinkDao;
    }

    public void store(BroadcastDomain domain, Date now) throws BridgeTopologyException {
        for (SharedSegment segment : domain.getSharedSegments()) {
            segment.getDesignatedPort();
        }
        for (SharedSegment segment : domain.getSharedSegments()) {
            for (BridgeBridgeLink link : SharedSegment.getBridgeBridgeLinks((SharedSegment)segment)) {
                link.setBridgeBridgeLinkLastPollTime(new Date());
                this.saveBridgeBridgeLink(link);
            }
            for (BridgeBridgeLink link : SharedSegment.getBridgeMacLinks((SharedSegment)segment)) {
                link.setBridgeMacLinkLastPollTime(new Date());
                this.saveBridgeMacLink((BridgeMacLink)link);
            }
        }
        domain.getForwarding().stream().filter(forward -> forward.getMacs().size() > 0).forEach(forward -> {
            for (BridgeMacLink link : BridgeForwardingTableEntry.create((BridgePortWithMacs)forward, (BridgeMacLink.BridgeMacLinkType)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER)) {
                link.setBridgeMacLinkLastPollTime(new Date());
                this.saveBridgeMacLink(link);
            }
        });
        for (Integer nodeid : domain.getBridgeNodesOnDomain()) {
            this.m_bridgeMacLinkDao.deleteByNodeIdOlderThen(nodeid, now);
            this.m_bridgeBridgeLinkDao.deleteByNodeIdOlderThen(nodeid, now);
            this.m_bridgeBridgeLinkDao.deleteByDesignatedNodeIdOlderThen(nodeid, now);
        }
        try {
            this.m_bridgeMacLinkDao.flush();
        }
        catch (Exception e) {
            LOG.error("BridgeMacLinkDao: {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            this.m_bridgeBridgeLinkDao.flush();
        }
        catch (Exception e) {
            LOG.error("BridgeBridgeLinkDao: {}", (Object)e.getMessage(), (Object)e);
        }
        this.updatesAvailable();
    }

    @Transactional
    protected void saveBridgeMacLink(final BridgeMacLink saveMe) {
        new UpsertTemplate<BridgeMacLink, BridgeMacLinkDao>(this.m_transactionManager, this.m_bridgeMacLinkDao){

            protected BridgeMacLink query() {
                return ((BridgeMacLinkDao)this.m_dao).getByNodeIdBridgePortMac(saveMe.getNode().getId(), saveMe.getBridgePort(), saveMe.getMacAddress());
            }

            protected BridgeMacLink doUpdate(BridgeMacLink link) {
                link.merge(saveMe);
                ((BridgeMacLinkDao)this.m_dao).update((Object)link);
                ((BridgeMacLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeMacLink doInsert() {
                if (saveMe.getBridgeMacLinkLastPollTime() == null) {
                    saveMe.setBridgeMacLinkLastPollTime(saveMe.getBridgeMacLinkCreateTime());
                }
                ((BridgeMacLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeMacLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    protected void saveBridgeBridgeLink(final BridgeBridgeLink saveMe) {
        new UpsertTemplate<BridgeBridgeLink, BridgeBridgeLinkDao>(this.m_transactionManager, this.m_bridgeBridgeLinkDao){

            protected BridgeBridgeLink query() {
                return ((BridgeBridgeLinkDao)this.m_dao).getByNodeIdBridgePort(saveMe.getNode().getId(), saveMe.getBridgePort());
            }

            protected BridgeBridgeLink doUpdate(BridgeBridgeLink link) {
                link.merge(saveMe);
                ((BridgeBridgeLinkDao)this.m_dao).update((Object)link);
                ((BridgeBridgeLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeBridgeLink doInsert() {
                if (saveMe.getBridgeBridgeLinkLastPollTime() == null) {
                    saveMe.setBridgeBridgeLinkLastPollTime(saveMe.getBridgeBridgeLinkCreateTime());
                }
                ((BridgeBridgeLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeBridgeLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public void load() {
        this.m_domains = this.getAllPersisted();
        for (BroadcastDomain domain : this.m_domains) {
            for (Bridge bridge : domain.getBridges()) {
                bridge.clear();
                List elems = this.m_bridgeElementDao.findByNodeId(bridge.getNodeId());
                bridge.getIdentifiers().addAll(Bridge.getIdentifier((List)elems));
                bridge.setDesignated(Bridge.getDesignated((List)elems));
            }
        }
    }

    public void delete(int nodeid) throws BridgeTopologyException {
        this.m_bridgeElementDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_bridgeElementDao.flush();
        this.m_bridgeStpLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_bridgeStpLinkDao.flush();
        this.reconcile(this.getBroadcastDomain(nodeid), nodeid);
        this.m_bridgeBridgeLinkDao.deleteByDesignatedNodeId(Integer.valueOf(nodeid));
        this.m_bridgeBridgeLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_bridgeBridgeLinkDao.flush();
        this.m_bridgeMacLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_bridgeMacLinkDao.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BroadcastDomain getBroadcastDomain(int nodeId) {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            Iterator<BroadcastDomain> iterator = this.m_domains.iterator();
            while (iterator.hasNext()) {
                BroadcastDomain domain;
                BroadcastDomain broadcastDomain = domain = iterator.next();
                synchronized (broadcastDomain) {
                    Bridge bridge = domain.getBridge(nodeId);
                    if (bridge != null) {
                        return domain;
                    }
                }
            }
        }
        return null;
    }

    public BroadcastDomain reconcile(BroadcastDomain domain, int nodeId) throws BridgeTopologyException {
        Date now = new Date();
        if (domain == null || domain.isEmpty()) {
            LOG.warn("reconcileTopologyForDeleteNode: node: {}, start: null domain or empty", (Object)nodeId);
            return domain;
        }
        if (domain.getBridge(nodeId) == null) {
            LOG.info("reconcileTopologyForDeleteNode: node: {}, not on domain", (Object)nodeId);
            return domain;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("reconcileTopologyForDeleteNode: node:[{}], domain:\n{}", (Object)nodeId, (Object)domain.printTopology());
        }
        LOG.info("reconcileTopologyForDeleteNode: node:[{}], start: save topology for domain", (Object)nodeId);
        BroadcastDomain.removeBridge((BroadcastDomain)domain, (int)nodeId);
        this.store(domain, now);
        LOG.info("reconcileTopologyForDeleteNode: node:[{}], end: save topology for domain", (Object)nodeId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("reconcileTopologyForDeleteNode: node:[{}], resulting domain: {}", (Object)nodeId, (Object)domain.printTopology());
        }
        if (domain.isEmpty()) {
            this.cleanBroadcastDomains();
            LOG.info("reconcileTopologyForDeleteNode: node:[{}], empty domain", (Object)nodeId);
            return domain;
        }
        if (domain.getRootBridge() == null) {
            throw new BridgeTopologyException("reconcileTopologyForDeleteNode: Domain without root", (Topology)domain);
        }
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanBroadcastDomains() {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            this.m_domains.removeIf(BroadcastDomain::isEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBridgeOnDomain(BroadcastDomain domain, Integer nodeId) {
        if (domain == null) {
            return;
        }
        BroadcastDomain broadcastDomain = domain;
        synchronized (broadcastDomain) {
            for (Bridge bridge : domain.getBridges()) {
                if (bridge.getNodeId().intValue() != nodeId.intValue()) continue;
                bridge.clear();
                List elems = this.m_bridgeElementDao.findByNodeId(nodeId);
                bridge.getIdentifiers().addAll(Bridge.getIdentifier((List)elems));
                bridge.setDesignated(Bridge.getDesignated((List)elems));
                break;
            }
        }
    }

    public List<BridgeElement> getBridgeElements(Set<Integer> nodes) {
        ArrayList<BridgeElement> elems = new ArrayList<BridgeElement>();
        for (Integer nodeid : nodes) {
            elems.addAll(this.m_bridgeElementDao.findByNodeId(nodeid));
        }
        return elems;
    }

    public void store(int nodeId, BridgeElement bridge) {
        if (bridge == null) {
            return;
        }
        this.saveBridgeElement(nodeId, bridge);
        this.updatesAvailable();
    }

    @Transactional
    protected void saveBridgeElement(final int nodeId, final BridgeElement saveMe) {
        new UpsertTemplate<BridgeElement, BridgeElementDao>(this.m_transactionManager, this.m_bridgeElementDao){

            protected BridgeElement query() {
                return ((BridgeElementDao)this.m_dao).getByNodeIdVlan(Integer.valueOf(nodeId), saveMe.getVlan());
            }

            protected BridgeElement doUpdate(BridgeElement bridge) {
                bridge.merge(saveMe);
                ((BridgeElementDao)this.m_dao).update((Object)bridge);
                ((BridgeElementDao)this.m_dao).flush();
                return bridge;
            }

            protected BridgeElement doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setBridgeNodeLastPollTime(saveMe.getBridgeNodeCreateTime());
                ((BridgeElementDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeElementDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public void store(int nodeId, BridgeStpLink link) {
        if (link == null) {
            return;
        }
        this.saveBridgeStpLink(nodeId, link);
    }

    @Transactional
    protected void saveBridgeStpLink(final int nodeId, final BridgeStpLink saveMe) {
        new UpsertTemplate<BridgeStpLink, BridgeStpLinkDao>(this.m_transactionManager, this.m_bridgeStpLinkDao){

            protected BridgeStpLink query() {
                return ((BridgeStpLinkDao)this.m_dao).getByNodeIdBridgePort(Integer.valueOf(nodeId), saveMe.getStpPort());
            }

            protected BridgeStpLink doUpdate(BridgeStpLink link) {
                link.merge(saveMe);
                ((BridgeStpLinkDao)this.m_dao).update((Object)link);
                ((BridgeStpLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeStpLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setBridgeStpLinkLastPollTime(saveMe.getBridgeStpLinkCreateTime());
                ((BridgeStpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeStpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(int nodeId, List<BridgeForwardingTableEntry> bft) {
        HashSet<BridgeForwardingTableEntry> effectiveBFT = new HashSet<BridgeForwardingTableEntry>();
        for (BridgeForwardingTableEntry link : bft) {
            link.setNodeId(Integer.valueOf(nodeId));
            effectiveBFT.add(link);
        }
        Map<Integer, Set<BridgeForwardingTableEntry>> map = this.m_nodetoBroadcastDomainMap;
        synchronized (map) {
            this.m_nodetoBroadcastDomainMap.put(nodeId, effectiveBFT);
        }
    }

    public synchronized Map<Integer, Set<BridgeForwardingTableEntry>> getUpdateBftMap() {
        return this.m_nodetoBroadcastDomainMap;
    }

    public void reconcile(int nodeId, Date now) {
        this.m_bridgeElementDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeElementDao.flush();
        this.m_bridgeStpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeStpLinkDao.flush();
    }

    public synchronized Set<BroadcastDomain> findAll() {
        return this.m_domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BroadcastDomain domain) {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            this.m_domains.add(domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BridgeForwardingTableEntry> useBridgeTopologyUpdateBFT(int nodeid) {
        Map<Integer, Set<BridgeForwardingTableEntry>> map = this.m_nodetoBroadcastDomainMap;
        synchronized (map) {
            return this.m_nodetoBroadcastDomainMap.remove(nodeid);
        }
    }

    public List<SharedSegment> getSharedSegments(int nodeid) {
        ArrayList<SharedSegment> segments = new ArrayList<SharedSegment>();
        block6: for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findByDesignatedNodeId(Integer.valueOf(nodeid))) {
            for (SharedSegment sharedSegment : segments) {
                if (!sharedSegment.containsPort(BridgePort.getFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                sharedSegment.getBridgePortsOnSegment().add(BridgePort.getFromBridgeBridgeLink((BridgeBridgeLink)link));
                continue block6;
            }
            try {
                segments.add(SharedSegment.create((BridgeBridgeLink)link));
            }
            catch (BridgeTopologyException e) {
                LOG.error("getBridgeNodeSharedSegments: cannot create shared segment {}", (Object)e.getMessage(), (Object)e);
                return new ArrayList<SharedSegment>();
            }
        }
        HashSet<BridgePort> designated = new HashSet<BridgePort>();
        for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findByNodeId(Integer.valueOf(nodeid))) {
            designated.add(BridgePort.getFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link));
        }
        for (BridgePort designatedport : designated) {
            block10: for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.getByDesignatedNodeIdBridgePort(designatedport.getNodeId(), designatedport.getBridgePort())) {
                for (SharedSegment segment : segments) {
                    if (!segment.containsPort(BridgePort.getFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                    segment.getBridgePortsOnSegment().add(BridgePort.getFromBridgeBridgeLink((BridgeBridgeLink)link));
                    continue block10;
                }
                try {
                    segments.add(SharedSegment.create((BridgeBridgeLink)link));
                }
                catch (BridgeTopologyException e) {
                    LOG.error("getBridgeSharedSegments: cannot create shared segment {}", (Object)e.getMessage(), (Object)e);
                    return new ArrayList<SharedSegment>();
                }
            }
        }
        block12: for (BridgeBridgeLink link : this.m_bridgeMacLinkDao.findByNodeId(Integer.valueOf(nodeid))) {
            if (link.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER) continue;
            for (SharedSegment segment : segments) {
                if (!segment.containsPort(BridgePort.getFromBridgeMacLink((BridgeMacLink)link))) continue;
                segment.getMacsOnSegment().add(link.getMacAddress());
                continue block12;
            }
            try {
                segments.add(SharedSegment.create((BridgeMacLink)link));
            }
            catch (BridgeTopologyException bridgeTopologyException) {
                LOG.error("getBridgeSharedSegments: cannot create shared segment {}", (Object)bridgeTopologyException.getMessage(), (Object)bridgeTopologyException);
                return new ArrayList<SharedSegment>();
            }
        }
        return segments;
    }

    public SharedSegment getSharedSegment(String mac) {
        LOG.debug("getHostNodeSharedSegment: founding segment for mac:{}", (Object)mac);
        List links = this.m_bridgeMacLinkDao.findByMacAddress(mac).stream().filter(maclink -> maclink.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK).collect(Collectors.toCollection(ArrayList::new));
        if (links.size() == 0) {
            LOG.info("getHostNodeSharedSegment: no segment found for mac:{}", (Object)mac);
            return SharedSegment.create();
        }
        if (links.size() > 1) {
            LOG.error("getHostNodeSharedSegment: more then one segment for mac:{}", (Object)mac);
            return SharedSegment.create();
        }
        BridgeMacLink link = (BridgeMacLink)links.iterator().next();
        SharedSegment segment = null;
        try {
            for (BridgeBridgeLink bblink : this.m_bridgeBridgeLinkDao.getByDesignatedNodeIdBridgePort(link.getNode().getId(), link.getBridgePort())) {
                if (segment == null) {
                    segment = SharedSegment.create((BridgeBridgeLink)bblink);
                    continue;
                }
                segment.getBridgePortsOnSegment().add(BridgePort.getFromBridgeBridgeLink((BridgeBridgeLink)bblink));
            }
            for (BridgeMacLink maclink2 : this.m_bridgeMacLinkDao.findByNodeIdBridgePort(link.getNode().getId(), link.getBridgePort())) {
                if (segment == null) {
                    segment = SharedSegment.create((BridgeMacLink)maclink2);
                    continue;
                }
                segment.getMacsOnSegment().add(maclink2.getMacAddress());
            }
        }
        catch (Exception e) {
            LOG.error("getHostNodeSharedSegment: cannot create shared segment {} for mac {} ", new Object[]{e.getMessage(), mac, e});
            return SharedSegment.create();
        }
        return segment;
    }

    public Set<BroadcastDomain> getAllPersisted() {
        Object domain;
        ArrayList<SharedSegment> bblsegments = new ArrayList<SharedSegment>();
        HashMap<Integer, Set> rootnodetodomainnodemap = new HashMap<Integer, Set>();
        HashMap<Integer, BridgePort> designatebridgemap = new HashMap<Integer, BridgePort>();
        for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findAll()) {
            boolean segmentnotfound = true;
            BridgePort bridgeport = BridgePort.getFromBridgeBridgeLink((BridgeBridgeLink)link);
            designatebridgemap.put(link.getNode().getId(), bridgeport);
            for (SharedSegment bblsegment : bblsegments) {
                if (!bblsegment.containsPort(BridgePort.getFromDesignatedBridgeBridgeLink((BridgeBridgeLink)link))) continue;
                bblsegment.getBridgePortsOnSegment().add(bridgeport);
                segmentnotfound = false;
                break;
            }
            if (segmentnotfound) {
                try {
                    bblsegments.add(SharedSegment.create((BridgeBridgeLink)link));
                }
                catch (BridgeTopologyException e) {
                    LOG.error("getAllPersisted: cannot create shared segment {}", (Object)e.getMessage(), (Object)e);
                    return new CopyOnWriteArraySet<BroadcastDomain>();
                }
            }
            if (rootnodetodomainnodemap.containsKey(link.getDesignatedNode().getId())) {
                ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).add(link.getNode().getId());
                if (!rootnodetodomainnodemap.containsKey(link.getNode().getId())) continue;
                ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).addAll((Collection)rootnodetodomainnodemap.remove(link.getNode().getId()));
                continue;
            }
            if (rootnodetodomainnodemap.containsKey(link.getNode().getId())) {
                Set dependentsnode = (Set)rootnodetodomainnodemap.remove(link.getNode().getId());
                dependentsnode.add(link.getNode().getId());
                Object rootdesignated = null;
                for (Integer rootid : rootnodetodomainnodemap.keySet()) {
                    if (!((Set)rootnodetodomainnodemap.get(rootid)).contains(link.getDesignatedNode().getId())) continue;
                    rootdesignated = rootid;
                    break;
                }
                if (rootdesignated != null) {
                    dependentsnode.add(link.getDesignatedNode().getId());
                    ((Set)rootnodetodomainnodemap.get(rootdesignated)).addAll(dependentsnode);
                    continue;
                }
                rootnodetodomainnodemap.put(link.getDesignatedNode().getId(), dependentsnode);
                continue;
            }
            Object rootdesignated = null;
            for (Object rootid : rootnodetodomainnodemap.keySet()) {
                if (!((Set)rootnodetodomainnodemap.get(rootid)).contains(link.getDesignatedNode().getId())) continue;
                rootdesignated = rootid;
                break;
            }
            if (rootdesignated != null) {
                ((Set)rootnodetodomainnodemap.get(rootdesignated)).add(link.getNode().getId());
                continue;
            }
            rootnodetodomainnodemap.put(link.getDesignatedNode().getId(), new HashSet());
            ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).add(link.getNode().getId());
        }
        LOG.info("getAllPersisted: bridge topology node set: {}", rootnodetodomainnodemap);
        ArrayList<SharedSegment> bmlsegments = new ArrayList<SharedSegment>();
        ArrayList<BridgeMacLink> forwarders = new ArrayList<BridgeMacLink>();
        block8: for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            if (link.getLinkType() == BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER) {
                forwarders.add(link);
                continue;
            }
            for (SharedSegment bblsegment : bblsegments) {
                if (!bblsegment.containsPort(BridgePort.getFromBridgeMacLink((BridgeMacLink)link))) continue;
                bblsegment.getMacsOnSegment().add(link.getMacAddress());
                continue block8;
            }
            for (SharedSegment bmlsegment : bmlsegments) {
                if (!bmlsegment.containsPort(BridgePort.getFromBridgeMacLink((BridgeMacLink)link))) continue;
                bmlsegment.getMacsOnSegment().add(link.getMacAddress());
                continue block8;
            }
            try {
                bmlsegments.add(SharedSegment.create((BridgeMacLink)link));
            }
            catch (BridgeTopologyException e) {
                LOG.error("getAllPersisted: cannot create shared segment {}", (Object)e.getMessage(), (Object)e);
                return new CopyOnWriteArraySet<BroadcastDomain>();
            }
        }
        CopyOnWriteArraySet<BroadcastDomain> domains = new CopyOnWriteArraySet<BroadcastDomain>();
        for (Integer rootnode : rootnodetodomainnodemap.keySet()) {
            domain = new BroadcastDomain();
            Bridge.createRootBridge((BroadcastDomain)domain, (Integer)rootnode);
            for (Integer bridgenodeId : (Set)rootnodetodomainnodemap.get(rootnode)) {
                Bridge.create((BroadcastDomain)domain, (Integer)bridgenodeId, (Integer)((BridgePort)designatebridgemap.get(bridgenodeId)).getBridgePort());
            }
            domains.add((BroadcastDomain)domain);
        }
        for (SharedSegment segment : bblsegments) {
            BroadcastDomain cdomain;
            domain = domains.iterator();
            while (domain.hasNext() && !BroadcastDomain.loadTopologyEntry((BroadcastDomain)(cdomain = (BroadcastDomain)domain.next()), (SharedSegment)segment)) {
            }
        }
        block15: for (SharedSegment segment : bmlsegments) {
            for (BroadcastDomain cdomain : domains) {
                if (!BroadcastDomain.loadTopologyEntry((BroadcastDomain)cdomain, (SharedSegment)segment)) continue;
                continue block15;
            }
            domain = new BroadcastDomain();
            Bridge.createRootBridge((BroadcastDomain)domain, (Integer)segment.getDesignatedBridge());
            BroadcastDomain.loadTopologyEntry((BroadcastDomain)domain, (SharedSegment)segment);
            domains.add((BroadcastDomain)domain);
        }
        block17: for (BridgeMacLink forwarder : forwarders) {
            for (BroadcastDomain domain2 : domains) {
                Bridge bridge = domain2.getBridge(forwarder.getNode().getId().intValue());
                if (bridge == null) continue;
                domain2.addForwarding(BridgePort.getFromBridgeMacLink((BridgeMacLink)forwarder), forwarder.getMacAddress());
                continue block17;
            }
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean collectBft(int nodeid, int maxsize) {
        if (this.getUpdateBftMap().size() + this.m_bridgecollectionsscheduled.size() >= maxsize) {
            return false;
        }
        Set<Integer> set = this.m_bridgecollectionsscheduled;
        synchronized (set) {
            this.m_bridgecollectionsscheduled.add(nodeid);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void collectedBft(int nodeid) {
        Set<Integer> set = this.m_bridgecollectionsscheduled;
        synchronized (set) {
            this.m_bridgecollectionsscheduled.remove(nodeid);
        }
    }

    public BridgeStpLinkDao getBridgeStpLinkDao() {
        return this.m_bridgeStpLinkDao;
    }

    public void setBridgeStpLinkDao(BridgeStpLinkDao bridgeStpLinkDao) {
        this.m_bridgeStpLinkDao = bridgeStpLinkDao;
    }

    public List<MacPort> getMacPorts() {
        HashMap macToMacPortMap = new HashMap();
        HashBasedTable nodeIfindexToMacPortTable = HashBasedTable.create();
        this.m_ipNetToMediaDao.findAll().stream().forEach(arg_0 -> BridgeTopologyServiceImpl.lambda$getMacPorts$3((Table)nodeIfindexToMacPortTable, macToMacPortMap, arg_0));
        List<MacPort> ports = nodeIfindexToMacPortTable.values().stream().collect(Collectors.toList());
        ports.stream().forEach(mp -> mp.getMacPortMap().keySet().stream().filter(mac -> macToMacPortMap.containsKey(mac)).forEach(mac -> ((Set)mp.getMacPortMap().get(mac)).addAll((Collection)((MacPort)macToMacPortMap.remove(mac)).getMacPortMap().get(mac))));
        ports.addAll(macToMacPortMap.values());
        return ports;
    }

    public List<TopologyShared> match() {
        ArrayList<TopologyShared> links = new ArrayList<TopologyShared>();
        List<MacPort> macPortMap = this.getMacPorts();
        this.m_domains.stream().forEach(dm -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("match: \n{}", (Object)dm.printTopology());
            }
            dm.getSharedSegments().stream().forEach(shs -> {
                try {
                    links.add(TopologyShared.of((SharedSegment)shs, macPortMap.stream().filter(mp -> shs.getMacsOnSegment().containsAll(mp.getMacPortMap().keySet())).collect(Collectors.toList())));
                }
                catch (BridgeTopologyException e) {
                    LOG.error("{} Cannot add shared segment to topology: {}", new Object[]{e.getMessage(), e.printTopology(), e});
                }
            });
        });
        return links;
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }

    private static /* synthetic */ void lambda$getMacPorts$3(Table nodeIfindexToMacPortTable, Map macToMacPortMap, IpNetToMedia m) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMacPorts: parsing: {}", (Object)m);
        }
        if (m.getNode() != null) {
            if (nodeIfindexToMacPortTable.contains((Object)m.getNode().getId(), (Object)m.getIfIndex())) {
                MacPort.merge((IpNetToMedia)m, (MacPort)((MacPort)nodeIfindexToMacPortTable.get((Object)m.getNode().getId(), (Object)m.getIfIndex())));
            } else {
                nodeIfindexToMacPortTable.put((Object)m.getNode().getId(), (Object)m.getIfIndex(), (Object)MacPort.create((IpNetToMedia)m));
            }
        } else if (macToMacPortMap.containsKey(m.getPhysAddress())) {
            MacPort.merge((IpNetToMedia)m, (MacPort)((MacPort)macToMacPortMap.get(m.getPhysAddress())));
        } else {
            macToMacPortMap.put(m.getPhysAddress(), MacPort.create((IpNetToMedia)m));
        }
    }
}

