/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.enlinkd.model.CdpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.CdpLink;
import org.opennms.netmgt.enlinkd.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.CdpElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.CdpLinkDao;
import org.opennms.netmgt.enlinkd.service.api.CdpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.CompositeKey;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class CdpTopologyServiceImpl
extends TopologyServiceImpl
implements CdpTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(CdpTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private CdpLinkDao m_cdpLinkDao;
    private CdpElementDao m_cdpElementDao;

    public void delete(int nodeid) {
        this.m_cdpElementDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_cdpLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_cdpElementDao.flush();
        this.m_cdpLinkDao.flush();
    }

    public void reconcile(int nodeId, Date now) {
        CdpElement element = this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getCdpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_cdpElementDao.delete((Object)element);
            this.m_cdpElementDao.flush();
        }
        this.m_cdpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_cdpLinkDao.flush();
    }

    @Transactional
    public void store(int nodeId, CdpElement element) {
        if (element == null) {
            return;
        }
        CdpElement dbelement = this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_cdpElementDao.saveOrUpdate((Object)dbelement);
            this.m_cdpElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setCdpNodeLastPollTime(element.getCdpNodeCreateTime());
        this.m_cdpElementDao.saveOrUpdate((Object)element);
        this.m_cdpElementDao.flush();
        this.updatesAvailable();
    }

    public void store(int nodeId, CdpLink link) {
        if (link == null) {
            return;
        }
        this.saveCdpLink(nodeId, link);
        this.updatesAvailable();
    }

    @Transactional
    protected void saveCdpLink(final int nodeId, final CdpLink saveMe) {
        new UpsertTemplate<CdpLink, CdpLinkDao>(this.m_transactionManager, this.m_cdpLinkDao){

            protected CdpLink query() {
                return ((CdpLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getCdpCacheIfIndex(), saveMe.getCdpCacheDeviceIndex());
            }

            protected CdpLink doUpdate(CdpLink dbCdpLink) {
                dbCdpLink.merge(saveMe);
                ((CdpLinkDao)this.m_dao).update((Object)dbCdpLink);
                ((CdpLinkDao)this.m_dao).flush();
                return dbCdpLink;
            }

            protected CdpLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setCdpLinkLastPollTime(saveMe.getCdpLinkCreateTime());
                ((CdpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((CdpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public List<TopologyConnection<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> match() {
        List cdpElements = this.getTopologyEntityCache().getCdpElementTopologyEntities();
        List allLinks = this.getTopologyEntityCache().getCdpLinkTopologyEntities();
        HashMap<Integer, Object> cdpelementmap = new HashMap<Integer, Object>();
        for (Object cdpelement : cdpElements) {
            cdpelementmap.put(cdpelement.getNodeId(), cdpelement);
        }
        HashMap<CompositeKey, CdpLinkTopologyEntity> targetLinkMap = new HashMap<CompositeKey, CdpLinkTopologyEntity>();
        for (CdpLinkTopologyEntity targetLink : allLinks) {
            CompositeKey key = new CompositeKey(new Object[]{targetLink.getCdpCacheDevicePort(), targetLink.getCdpInterfaceName(), ((CdpElementTopologyEntity)cdpelementmap.get(targetLink.getNodeId())).getCdpGlobalDeviceId(), targetLink.getCdpCacheDeviceId()});
            targetLinkMap.put(key, targetLink);
        }
        HashSet<Integer> parsed = new HashSet<Integer>();
        ArrayList<TopologyConnection<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> results = new ArrayList<TopologyConnection<CdpLinkTopologyEntity, CdpLinkTopologyEntity>>();
        for (CdpLinkTopologyEntity sourceLink : allLinks) {
            if (parsed.contains(sourceLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCdpLinks: source: {} ", (Object)sourceLink);
            }
            CdpElementTopologyEntity sourceCdpElement = (CdpElementTopologyEntity)cdpelementmap.get(sourceLink.getNodeId());
            CdpLinkTopologyEntity targetLink = (CdpLinkTopologyEntity)targetLinkMap.get(new CompositeKey(new Object[]{sourceLink.getCdpInterfaceName(), sourceLink.getCdpCacheDevicePort(), sourceLink.getCdpCacheDeviceId(), sourceCdpElement.getCdpGlobalDeviceId()}));
            if (targetLink == null) {
                LOG.debug("getCdpLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().equals(targetLink.getId()) || parsed.contains(targetLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCdpLinks: cdp: {}, target: {} ", (Object)sourceLink.getCdpCacheDevicePort(), (Object)targetLink);
            }
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add((TopologyConnection<CdpLinkTopologyEntity, CdpLinkTopologyEntity>)TopologyConnection.of((Object)sourceLink, (Object)targetLink));
        }
        return results;
    }

    public List<CdpElementTopologyEntity> findAllCdpElements() {
        return this.getTopologyEntityCache().getCdpElementTopologyEntities();
    }

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }

    public CdpElementDao getCdpElementDao() {
        return this.m_cdpElementDao;
    }

    public void setCdpElementDao(CdpElementDao cdpElementDao) {
        this.m_cdpElementDao = cdpElementDao;
    }
}

