/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.Date;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;
import org.opennms.netmgt.enlinkd.service.api.IpNetToMediaTopologyService;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class IpNetToMediaTopologyServiceImpl
implements IpNetToMediaTopologyService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private IpNetToMediaDao m_ipNetToMediaDao;

    public void delete(int nodeid) {
        this.m_ipNetToMediaDao.deleteBySourceNodeId(Integer.valueOf(nodeid));
        this.m_ipNetToMediaDao.flush();
    }

    public void reconcile(int nodeId, Date now) {
        this.m_ipNetToMediaDao.deleteBySourceNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ipNetToMediaDao.flush();
    }

    public void store(int nodeId, IpNetToMedia ipnettomedia) {
        if (ipnettomedia == null) {
            return;
        }
        this.saveIpNetToMedia(nodeId, ipnettomedia);
    }

    @Transactional
    protected void saveIpNetToMedia(final int nodeId, final IpNetToMedia saveMe) {
        new UpsertTemplate<IpNetToMedia, IpNetToMediaDao>(this.m_transactionManager, this.m_ipNetToMediaDao){

            protected IpNetToMedia query() {
                return ((IpNetToMediaDao)this.m_dao).getByNetAndPhysAddress(saveMe.getNetAddress(), saveMe.getPhysAddress());
            }

            protected IpNetToMedia doUpdate(IpNetToMedia dbIpNetToMedia) {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setSourceNode(node);
                dbIpNetToMedia.merge(saveMe);
                ((IpNetToMediaDao)this.m_dao).update((Object)dbIpNetToMedia);
                ((IpNetToMediaDao)this.m_dao).flush();
                return dbIpNetToMedia;
            }

            protected IpNetToMedia doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setSourceNode(node);
                saveMe.setLastPollTime(saveMe.getCreateTime());
                ((IpNetToMediaDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((IpNetToMediaDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }
}

