/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.Date;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.enlinkd.persistence.api.OspfElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.OspfLinkDao;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class OspfTopologyServiceImpl
implements OspfTopologyService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private OspfLinkDao m_ospfLinkDao;
    private OspfElementDao m_ospfElementDao;

    public void delete(int nodeid) {
        this.m_ospfElementDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_ospfLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_ospfElementDao.flush();
        this.m_ospfLinkDao.flush();
    }

    public void reconcile(int nodeId, Date now) {
        OspfElement element = this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getOspfNodeLastPollTime().getTime() < now.getTime()) {
            this.m_ospfElementDao.delete((Object)element);
            this.m_ospfElementDao.flush();
        }
        this.m_ospfLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ospfLinkDao.flush();
    }

    @Transactional
    public void store(int nodeId, OspfElement element) {
        if (element == null) {
            return;
        }
        OspfElement dbelement = this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_ospfElementDao.saveOrUpdate((Object)dbelement);
            this.m_ospfElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setOspfNodeLastPollTime(element.getOspfNodeCreateTime());
        this.m_ospfElementDao.saveOrUpdate((Object)element);
        this.m_ospfElementDao.flush();
    }

    public void store(int nodeId, OspfLink link) {
        if (link == null) {
            return;
        }
        this.saveOspfLink(nodeId, link);
    }

    private void saveOspfLink(final int nodeId, final OspfLink saveMe) {
        new UpsertTemplate<OspfLink, OspfLinkDao>(this.m_transactionManager, this.m_ospfLinkDao){

            protected OspfLink query() {
                return ((OspfLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getOspfRemRouterId(), saveMe.getOspfRemIpAddr(), saveMe.getOspfRemAddressLessIndex());
            }

            protected OspfLink doUpdate(OspfLink dbOspfLink) {
                dbOspfLink.merge(saveMe);
                ((OspfLinkDao)this.m_dao).update((Object)dbOspfLink);
                ((OspfLinkDao)this.m_dao).flush();
                return dbOspfLink;
            }

            protected OspfLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setOspfLinkLastPollTime(saveMe.getOspfLinkCreateTime());
                ((OspfLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((OspfLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public OspfElementDao getOspfElementDao() {
        return this.m_ospfElementDao;
    }

    public void setOspfElementDao(OspfElementDao ospfElementDao) {
        this.m_ospfElementDao = ospfElementDao;
    }
}

