/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PrimaryType;

public class NodeTopologyServiceImpl
implements NodeTopologyService {
    private NodeDao m_nodeDao;

    public List<Node> findAllSnmpNode() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Criteria criteria = new Criteria(OnmsNode.class);
        criteria.setAliases(Arrays.asList(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
        criteria.addRestriction((Restriction)new EqRestriction("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY));
        for (OnmsNode node : this.m_nodeDao.findMatching(criteria)) {
            nodes.add(new Node(node.getId().intValue(), node.getLabel(), node.getPrimaryInterface().getIpAddress(), node.getSysObjectId(), node.getSysName(), node.getLocation() == null ? null : node.getLocation().getLocationName()));
        }
        return nodes;
    }

    public Node getSnmpNode(int nodeid) {
        Criteria criteria = new Criteria(OnmsNode.class);
        criteria.setAliases(Arrays.asList(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
        criteria.addRestriction((Restriction)new EqRestriction("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY));
        criteria.addRestriction((Restriction)new EqRestriction("id", (Object)nodeid));
        List nodes = this.m_nodeDao.findMatching(criteria);
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            return new Node(node.getId().intValue(), node.getLabel(), node.getPrimaryInterface().getIpAddress(), node.getSysObjectId(), node.getSysName(), node.getLocation() == null ? null : node.getLocation().getLocationName());
        }
        return null;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public List<OnmsNode> findAll() {
        return this.m_nodeDao.findAll();
    }
}

