/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.Date;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.IsIsElement;
import org.opennms.netmgt.enlinkd.model.IsIsLink;
import org.opennms.netmgt.enlinkd.persistence.api.IsIsElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.IsIsLinkDao;
import org.opennms.netmgt.enlinkd.service.api.IsisTopologyService;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class IsisTopologyServiceImpl
implements IsisTopologyService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private IsIsLinkDao m_isisLinkDao;
    private IsIsElementDao m_isisElementDao;

    public void delete(int nodeid) {
        this.m_isisElementDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_isisLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_isisElementDao.flush();
        this.m_isisLinkDao.flush();
    }

    public void reconcile(int nodeId, Date now) {
        IsIsElement element = this.m_isisElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getIsisNodeLastPollTime().getTime() < now.getTime()) {
            this.m_isisElementDao.delete((Object)element);
            this.m_isisElementDao.flush();
        }
        this.m_isisLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_isisLinkDao.flush();
    }

    public void store(int nodeId, IsIsLink link) {
        if (link == null) {
            return;
        }
        this.saveIsisLink(nodeId, link);
    }

    @Transactional
    protected void saveIsisLink(final int nodeId, final IsIsLink saveMe) {
        new UpsertTemplate<IsIsLink, IsIsLinkDao>(this.m_transactionManager, this.m_isisLinkDao){

            protected IsIsLink query() {
                return ((IsIsLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getIsisCircIndex(), saveMe.getIsisISAdjIndex());
            }

            protected IsIsLink doUpdate(IsIsLink dbIsIsLink) {
                dbIsIsLink.merge(saveMe);
                ((IsIsLinkDao)this.m_dao).update((Object)dbIsIsLink);
                ((IsIsLinkDao)this.m_dao).flush();
                return dbIsIsLink;
            }

            protected IsIsLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setIsisLinkLastPollTime(saveMe.getIsisLinkCreateTime());
                ((IsIsLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((IsIsLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    public void store(int nodeId, IsIsElement element) {
        if (element == null) {
            return;
        }
        IsIsElement dbelement = this.m_isisElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_isisElementDao.saveOrUpdate((Object)dbelement);
            this.m_isisElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setIsisNodeLastPollTime(element.getIsisNodeCreateTime());
        this.m_isisElementDao.saveOrUpdate((Object)element);
        this.m_isisElementDao.flush();
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isisLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isisLinkDao) {
        this.m_isisLinkDao = isisLinkDao;
    }

    public IsIsElementDao getIsisElementDao() {
        return this.m_isisElementDao;
    }

    public void setIsisElementDao(IsIsElementDao isisElementDao) {
        this.m_isisElementDao = isisElementDao;
    }
}

