/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.Date;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.enlinkd.model.CdpLink;
import org.opennms.netmgt.enlinkd.persistence.api.CdpElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.CdpLinkDao;
import org.opennms.netmgt.enlinkd.service.api.CdpTopologyService;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class CdpTopologyServiceImpl
implements CdpTopologyService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private CdpLinkDao m_cdpLinkDao;
    private CdpElementDao m_cdpElementDao;

    public void delete(int nodeid) {
        this.m_cdpElementDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_cdpLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_cdpElementDao.flush();
        this.m_cdpLinkDao.flush();
    }

    public void reconcile(int nodeId, Date now) {
        CdpElement element = this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getCdpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_cdpElementDao.delete((Object)element);
            this.m_cdpElementDao.flush();
        }
        this.m_cdpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_cdpLinkDao.flush();
    }

    @Transactional
    public void store(int nodeId, CdpElement element) {
        if (element == null) {
            return;
        }
        CdpElement dbelement = this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_cdpElementDao.saveOrUpdate((Object)dbelement);
            this.m_cdpElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setCdpNodeLastPollTime(element.getCdpNodeCreateTime());
        this.m_cdpElementDao.saveOrUpdate((Object)element);
        this.m_cdpElementDao.flush();
    }

    public void store(int nodeId, CdpLink link) {
        if (link == null) {
            return;
        }
        this.saveCdpLink(nodeId, link);
    }

    @Transactional
    protected void saveCdpLink(final int nodeId, final CdpLink saveMe) {
        new UpsertTemplate<CdpLink, CdpLinkDao>(this.m_transactionManager, this.m_cdpLinkDao){

            protected CdpLink query() {
                return ((CdpLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getCdpCacheIfIndex(), saveMe.getCdpCacheDeviceIndex());
            }

            protected CdpLink doUpdate(CdpLink dbCdpLink) {
                dbCdpLink.merge(saveMe);
                ((CdpLinkDao)this.m_dao).update((Object)dbCdpLink);
                ((CdpLinkDao)this.m_dao).flush();
                return dbCdpLink;
            }

            protected CdpLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setCdpLinkLastPollTime(saveMe.getCdpLinkCreateTime());
                ((CdpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((CdpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }

    public CdpElementDao getCdpElementDao() {
        return this.m_cdpElementDao;
    }

    public void setCdpElementDao(CdpElementDao cdpElementDao) {
        this.m_cdpElementDao = cdpElementDao;
    }
}

