/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class BridgePortWithMacs
implements Topology {
    private final BridgePort m_port;
    private final Set<String> m_macs;

    public static BridgePortWithMacs create(BridgePort port, Set<String> macs) throws BridgeTopologyException {
        if (port == null) {
            throw new BridgeTopologyException("cannot create BridgePortWithMacs bridge port is null");
        }
        if (macs == null) {
            throw new BridgeTopologyException("cannot create BridgePortWithMacs macs is null");
        }
        return new BridgePortWithMacs(port, macs);
    }

    private BridgePortWithMacs(BridgePort port, Set<String> macs) {
        this.m_port = port;
        this.m_macs = macs;
    }

    public BridgePort getPort() {
        return this.m_port;
    }

    public Set<String> getMacs() {
        return this.m_macs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BridgePortWithMacs that = (BridgePortWithMacs)o;
        return Objects.equals(this.m_port, that.m_port);
    }

    public int hashCode() {
        return Objects.hash(this.m_port);
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append(this.m_port.printTopology());
        strbfr.append(" macs:");
        strbfr.append(this.m_macs);
        return strbfr.toString();
    }
}

