/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.MacCloud;
import org.opennms.netmgt.enlinkd.service.api.MacPort;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class TopologyShared
implements Topology {
    private MacCloud cloud;
    private BridgePort designated;
    private List<BridgePort> left;
    private List<MacPort> right;

    public static TopologyShared of(SharedSegment shs, List<MacPort> macPortsOnSegment) throws BridgeTopologyException {
        TopologyShared tps = new TopologyShared(new ArrayList<BridgePort>(shs.getBridgePortsOnSegment()), macPortsOnSegment, shs.getDesignatedPort());
        HashSet<String> noPortMacs = new HashSet<String>(shs.getMacsOnSegment());
        macPortsOnSegment.stream().forEach(mp -> noPortMacs.removeAll(mp.getMacPortMap().keySet()));
        if (noPortMacs.size() > 0) {
            tps.setCloud(MacCloud.create(noPortMacs));
        }
        return tps;
    }

    private TopologyShared(List<BridgePort> left, List<MacPort> right, BridgePort top) {
        this.designated = top;
        this.left = left;
        this.right = right;
    }

    public List<BridgePort> getBridgePorts() {
        return this.left;
    }

    public List<MacPort> getMacPorts() {
        return this.right;
    }

    public BridgePort getUpPort() {
        return this.designated;
    }

    public MacCloud getCloud() {
        return this.cloud;
    }

    public void setCloud(MacCloud cloud) {
        this.cloud = cloud;
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("shared -> designated bridge:[");
        strbfr.append(this.designated.printTopology());
        strbfr.append("]\n");
        for (BridgePort blink : this.left) {
            strbfr.append("        -> port:");
            if (blink == null) {
                strbfr.append("[null]");
            } else {
                strbfr.append(blink.printTopology());
            }
            strbfr.append("\n");
        }
        for (MacPort port : this.right) {
            strbfr.append("        -> macs:");
            strbfr.append(port.printTopology());
        }
        if (this.cloud != null) {
            strbfr.append("        -> macs:");
            strbfr.append(this.cloud.printTopology());
        }
        return strbfr.toString();
    }
}

