/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="lldpElement")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public final class LldpElement
implements Serializable {
    private static final long serialVersionUID = -3134355798509685991L;
    private Integer m_id;
    private String m_lldpChassisId;
    private String m_lldpSysname;
    private LldpUtils.LldpChassisIdSubType m_lldpChassisIdSubType;
    private Date m_lldpNodeCreateTime = new Date();
    private Date m_lldpNodeLastPollTime;
    private OnmsNode m_node;

    public LldpElement() {
    }

    public LldpElement(OnmsNode node, String chassisId, String sysName, LldpUtils.LldpChassisIdSubType chassisIdSubType) {
        this.setNode(node);
        this.setLldpChassisId(chassisId);
        this.setLldpSysname(sysName);
        this.setLldpChassisIdSubType(chassisIdSubType);
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Column(name="lldpChassisIdSubType", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.LldpChassisIdSubTypeUserType")
    public LldpUtils.LldpChassisIdSubType getLldpChassisIdSubType() {
        return this.m_lldpChassisIdSubType;
    }

    @Column(name="lldpSysname", length=256, nullable=false)
    public String getLldpSysname() {
        return this.m_lldpSysname;
    }

    @Column(name="lldpChassisId", length=256, nullable=false)
    public String getLldpChassisId() {
        return this.m_lldpChassisId;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lldpNodeCreateTime", nullable=false)
    public Date getLldpNodeCreateTime() {
        return this.m_lldpNodeCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lldpNodeLastPollTime", nullable=false)
    public Date getLldpNodeLastPollTime() {
        return this.m_lldpNodeLastPollTime;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public void setLldpSysname(String lldpSysname) {
        this.m_lldpSysname = lldpSysname;
    }

    public void setLldpChassisId(String lldpChassisId) {
        this.m_lldpChassisId = lldpChassisId;
    }

    public void setLldpChassisIdSubType(LldpUtils.LldpChassisIdSubType lldpChassisIdSubType) {
        this.m_lldpChassisIdSubType = lldpChassisIdSubType;
    }

    public void setLldpNodeCreateTime(Date lldpNodeCreateTime) {
        this.m_lldpNodeCreateTime = lldpNodeCreateTime;
    }

    public void setLldpNodeLastPollTime(Date lldpNodeLastPollTime) {
        this.m_lldpNodeLastPollTime = lldpNodeLastPollTime;
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append("lldpelement: nodeid:[");
        strb.append(this.getNode().getId());
        strb.append("], chassis type/id:[");
        strb.append(LldpUtils.LldpChassisIdSubType.getTypeString((Integer)this.getLldpChassisIdSubType().getValue()));
        strb.append("/");
        strb.append(this.getLldpChassisId());
        strb.append("], sysname: ");
        strb.append(this.getLldpSysname());
        strb.append("]");
        return strb.toString();
    }

    public void merge(LldpElement element) {
        if (element == null) {
            return;
        }
        this.setLldpChassisId(element.getLldpChassisId());
        this.setLldpChassisIdSubType(element.getLldpChassisIdSubType());
        this.setLldpSysname(element.getLldpSysname());
        this.setLldpNodeLastPollTime(element.getLldpNodeCreateTime());
    }
}

