/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.util.Optional;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.ReadOnlyEntity;

@ReadOnlyEntity
public class SnmpInterfaceTopologyEntity {
    private final Integer id;
    private final Integer ifIndex;
    private final String ifName;
    private final String ifAlias;
    private final Long ifSpeed;
    private final Integer nodeId;

    public SnmpInterfaceTopologyEntity(Integer id, Integer ifIndex, String ifName, String ifAlias, Long ifSpeed, Integer nodeId) {
        this.id = id;
        this.ifIndex = ifIndex;
        this.ifName = ifName;
        this.ifAlias = ifAlias;
        this.ifSpeed = ifSpeed;
        this.nodeId = nodeId;
    }

    public static SnmpInterfaceTopologyEntity create(OnmsSnmpInterface snmpInterface) {
        return new SnmpInterfaceTopologyEntity(snmpInterface.getId(), snmpInterface.getIfIndex(), snmpInterface.getIfName(), snmpInterface.getIfAlias(), snmpInterface.getIfSpeed(), Optional.ofNullable(snmpInterface.getNode()).map(OnmsNode::getId).orElse(null));
    }

    public Integer getId() {
        return this.id;
    }

    public String getNodeIdAsString() {
        if (this.getNodeId() != null) {
            return this.getNodeId().toString();
        }
        return null;
    }

    public Integer getIfIndex() {
        return this.ifIndex;
    }

    public String getIfName() {
        return this.ifName;
    }

    public String getIfAlias() {
        return this.ifAlias;
    }

    public Long getIfSpeed() {
        return this.ifSpeed;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        return "SnmpInterfaceTopologyEntity{id=" + this.id + ", ifIndex=" + this.ifIndex + ", ifName='" + this.ifName + '\'' + ", ifSpeed='" + this.ifSpeed + '\'' + ", nodeId=" + this.nodeId + '}';
    }
}

