/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.model.ReadOnlyEntity;

@ReadOnlyEntity
public class OspfLinkTopologyEntity {
    private final Integer id;
    private final Integer nodeId;
    private final InetAddress ospfIpAddr;
    private final InetAddress ospfRemIpAddr;
    private final Integer ospfIfIndex;

    public OspfLinkTopologyEntity(Integer id, Integer nodeId, InetAddress ospfIpAddr, InetAddress ospfRemIpAddr, Integer ospfIfIndex) {
        this.id = id;
        this.nodeId = nodeId;
        this.ospfIpAddr = ospfIpAddr;
        this.ospfRemIpAddr = ospfRemIpAddr;
        this.ospfIfIndex = ospfIfIndex;
    }

    public static OspfLinkTopologyEntity create(OspfLink link) {
        return new OspfLinkTopologyEntity(link.getId(), link.getNode().getId(), link.getOspfIpAddr(), link.getOspfRemIpAddr(), link.getOspfIfIndex());
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String getNodeIdAsString() {
        if (this.getNodeId() != null) {
            return this.getNodeId().toString();
        }
        return null;
    }

    public InetAddress getOspfIpAddr() {
        return this.ospfIpAddr;
    }

    public InetAddress getOspfRemIpAddr() {
        return this.ospfRemIpAddr;
    }

    public Integer getOspfIfIndex() {
        return this.ospfIfIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("nodeId", (Object)this.nodeId).add("ospfIpAddr", (Object)this.ospfIpAddr).add("ospfRemIpAddr", (Object)this.ospfRemIpAddr).add("ospfIfIndex", (Object)this.ospfIfIndex).toString();
    }
}

