/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import com.google.common.base.MoreObjects;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.model.ReadOnlyEntity;

@ReadOnlyEntity
public class LldpLinkTopologyEntity {
    private final Integer id;
    private final Integer nodeId;
    private final String lldpRemChassisId;
    private final String lldpRemPortId;
    private final LldpUtils.LldpPortIdSubType lldpRemPortIdSubType;
    private final String lldpPortId;
    private final LldpUtils.LldpPortIdSubType lldpPortIdSubType;
    private final String lldpPortDescr;
    private final Integer lldpPortIfindex;

    public LldpLinkTopologyEntity(Integer id, Integer nodeId, String lldpRemChassisId, String lldpRemPortId, LldpUtils.LldpPortIdSubType lldpRemPortIdSubType, String lldpPortId, LldpUtils.LldpPortIdSubType lldpPortIdSubType, String lldpPortDescr, Integer lldpPortIfindex) {
        this.id = id;
        this.nodeId = nodeId;
        this.lldpRemChassisId = lldpRemChassisId;
        this.lldpRemPortId = lldpRemPortId;
        this.lldpRemPortIdSubType = lldpRemPortIdSubType;
        this.lldpPortId = lldpPortId;
        this.lldpPortIdSubType = lldpPortIdSubType;
        this.lldpPortDescr = lldpPortDescr;
        this.lldpPortIfindex = lldpPortIfindex;
    }

    public LldpLinkTopologyEntity(LldpLink link) {
        this(link.getId(), link.getNode().getId(), link.getLldpRemChassisId(), link.getLldpRemPortId(), link.getLldpRemPortIdSubType(), link.getLldpPortId(), link.getLldpPortIdSubType(), link.getLldpPortDescr(), link.getLldpPortIfindex());
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String getNodeIdAsString() {
        if (this.getNodeId() != null) {
            return this.getNodeId().toString();
        }
        return null;
    }

    public String getLldpRemChassisId() {
        return this.lldpRemChassisId;
    }

    public String getLldpRemPortId() {
        return this.lldpRemPortId;
    }

    public LldpUtils.LldpPortIdSubType getLldpRemPortIdSubType() {
        return this.lldpRemPortIdSubType;
    }

    public String getLldpPortId() {
        return this.lldpPortId;
    }

    public LldpUtils.LldpPortIdSubType getLldpPortIdSubType() {
        return this.lldpPortIdSubType;
    }

    public String getLldpPortDescr() {
        return this.lldpPortDescr;
    }

    public Integer getLldpPortIfindex() {
        return this.lldpPortIfindex;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("nodeId", (Object)this.nodeId).add("lldpRemChassisId", (Object)this.lldpRemChassisId).add("lldpRemPortId", (Object)this.lldpRemPortId).add("lldpRemPortIdSubType", (Object)this.lldpRemPortIdSubType).add("lldpPortId", (Object)this.lldpPortId).add("lldpPortIdSubType", (Object)this.lldpPortIdSubType).add("lldpPortDescr", (Object)this.lldpPortDescr).add("lldpPortIfindex", (Object)this.lldpPortIfindex).toString();
    }
}

