/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.protocol.bridge;

import java.net.InetAddress;
import java.util.Date;
import java.util.Optional;
import org.opennms.enlinkd.generator.protocol.bridge.BridgeBuilderContext;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeElement;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class BridgeBuilder {
    private static final int VLAN_ID = 1;
    private OnmsNode node;
    private int bridgePortCounter;
    private BridgeBuilderContext context;

    public BridgeBuilder(OnmsNode node, int bridgePortCounter, BridgeBuilderContext context) {
        this.node = node;
        this.bridgePortCounter = bridgePortCounter;
        this.context = context;
        this.createAndSaveBridgeElement(node);
    }

    public BridgeBuilder connectToNewBridge(OnmsNode targetNode, int targetNodePortCounter) {
        ++this.bridgePortCounter;
        this.createAndPersistBridgeBridgeLink(targetNode, targetNodePortCounter, this.node, this.bridgePortCounter);
        return new BridgeBuilder(targetNode, targetNodePortCounter, this.context);
    }

    private void createAndSaveBridgeElement(OnmsNode node) {
        BridgeElement bridgeElement = this.createBridgeElement(node);
        this.context.getTopologyPersister().persist(bridgeElement);
    }

    private BridgeElement createBridgeElement(OnmsNode node) {
        BridgeElement bridge = new BridgeElement();
        bridge.setNode(node);
        bridge.setBaseBridgeAddress(this.context.getNextMacAddress());
        bridge.setBaseType(BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_TRANSPARENT_ONLY);
        bridge.setBridgeNodeLastPollTime(new Date());
        bridge.setBaseNumPorts(Integer.valueOf(3));
        bridge.setVlan(Integer.valueOf(1));
        bridge.setVlanname("default");
        return bridge;
    }

    private void createAndPersistBridgeBridgeLink(OnmsNode bridge, Integer port, OnmsNode designated, Integer designatedPort) {
        this.createAndPersistBridgeBridgeLink(bridge, port, true, designated, designatedPort, true);
    }

    private void createAndPersistBridgeBridgeLink(OnmsNode bridge, Integer port, boolean createSnmpInterface, OnmsNode designated, Integer designatedPort, boolean createdesignatedsnmpInterface) {
        if (createSnmpInterface) {
            this.context.getTopologyPersister().persist(this.createSnmpInterface(port, bridge));
        }
        if (createdesignatedsnmpInterface) {
            this.context.getTopologyPersister().persist(this.createSnmpInterface(designatedPort, designated));
        }
        this.context.getTopologyPersister().persist(this.createBridgeBridgeLink(bridge, designated, port, designatedPort));
    }

    public void createAndPersistCloud(int macaddresses, int ipaddresses) {
        int i;
        for (i = 0; i < ipaddresses; ++i) {
            String nextMac = this.context.getNextMacAddress();
            this.context.getTopologyPersister().persist(this.createIpNetToMedia(null, null, nextMac, this.context.getNextInetAddress(), this.node));
            this.context.getTopologyPersister().persist(this.createBridgeMacLink(this.node, this.bridgePortCounter, nextMac));
        }
        for (i = 0; i < macaddresses; ++i) {
            this.context.getTopologyPersister().persist(this.createBridgeMacLink(this.node, this.bridgePortCounter, this.context.getNextMacAddress()));
        }
    }

    public void createAndPersistBridgeMacLink(OnmsNode host, Integer hostPort, OnmsNode gateway) {
        this.createAndPersistBridgeMacLink(true, host, hostPort, gateway);
    }

    public void createAndPersistBridgeMacLink(boolean createsnmpinterface, OnmsNode host, Integer hostPort, OnmsNode gateway) {
        String mac = this.context.getNextMacAddress();
        InetAddress ip = this.context.getNextInetAddress();
        if (createsnmpinterface) {
            this.context.getTopologyPersister().persist(this.createSnmpInterface(this.bridgePortCounter, this.node));
        }
        if (hostPort != null) {
            OnmsSnmpInterface snmpInterface = this.createSnmpInterface(hostPort, host);
            this.context.getTopologyPersister().persist(snmpInterface);
            OnmsIpInterface ipInterface = this.createIpInterface(snmpInterface, ip);
            this.context.getTopologyPersister().persist(ipInterface);
        } else {
            OnmsIpInterface ipInterface = this.createIpInterface(null, ip);
            ipInterface.setNode(host);
            this.context.getTopologyPersister().persist(ipInterface);
        }
        this.context.getTopologyPersister().persist(this.createIpNetToMedia(host, hostPort, mac, ip, gateway));
        this.context.getTopologyPersister().persist(this.createBridgeMacLink(this.node, this.bridgePortCounter, mac));
    }

    protected OnmsIpInterface createIpInterface(OnmsSnmpInterface snmp, InetAddress inetAddress) {
        OnmsIpInterface ip = new OnmsIpInterface();
        ip.setSnmpInterface(snmp);
        ip.setIpLastCapsdPoll(new Date());
        ip.setNode((OnmsNode)Optional.ofNullable(snmp).map(OnmsSnmpInterface::getNode).orElse(null));
        ip.setIpAddress(inetAddress);
        return ip;
    }

    private BridgeMacLink createBridgeMacLink(OnmsNode bridge, Integer bridgePort, String mac) {
        BridgeMacLink bridgeMacLink = new BridgeMacLink();
        bridgeMacLink.setNode(bridge);
        bridgeMacLink.setBridgePort(bridgePort);
        bridgeMacLink.setBridgePortIfIndex(bridgePort);
        bridgeMacLink.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        bridgeMacLink.setMacAddress(mac);
        bridgeMacLink.setVlan(Integer.valueOf(1));
        bridgeMacLink.setBridgeMacLinkLastPollTime(new Date());
        return bridgeMacLink;
    }

    protected OnmsSnmpInterface createSnmpInterface(int ifIndex, OnmsNode node) {
        OnmsSnmpInterface onmsSnmpInterface = new OnmsSnmpInterface();
        onmsSnmpInterface.setNode(node);
        onmsSnmpInterface.setIfIndex(Integer.valueOf(ifIndex));
        onmsSnmpInterface.setIfType(Integer.valueOf(4));
        onmsSnmpInterface.setIfSpeed(Long.valueOf(5L));
        onmsSnmpInterface.setIfAdminStatus(Integer.valueOf(6));
        onmsSnmpInterface.setIfOperStatus(Integer.valueOf(7));
        onmsSnmpInterface.setLastCapsdPoll(new Date());
        onmsSnmpInterface.setLastSnmpPoll(new Date());
        return onmsSnmpInterface;
    }

    private BridgeBridgeLink createBridgeBridgeLink(OnmsNode node, OnmsNode designatedNode, int port, int designatedPort) {
        BridgeBridgeLink link = new BridgeBridgeLink();
        link.setBridgePortIfIndex(Integer.valueOf(port));
        link.setBridgePort(Integer.valueOf(port));
        link.setVlan(Integer.valueOf(1));
        link.setNode(node);
        link.setDesignatedNode(designatedNode);
        link.setDesignatedPort(Integer.valueOf(designatedPort));
        link.setDesignatedPortIfIndex(Integer.valueOf(designatedPort));
        link.setDesignatedVlan(Integer.valueOf(1));
        link.setBridgeBridgeLinkLastPollTime(new Date());
        return link;
    }

    private IpNetToMedia createIpNetToMedia(OnmsNode node, Integer ifindex, String mac, InetAddress inetAddress, OnmsNode sourceNode) {
        IpNetToMedia ipNetToMedia = new IpNetToMedia();
        ipNetToMedia.setCreateTime(new Date());
        if (node != null && ifindex == null) {
            ipNetToMedia.setIfIndex(Integer.valueOf(-1));
        } else {
            ipNetToMedia.setIfIndex(ifindex);
        }
        ipNetToMedia.setLastPollTime(new Date());
        ipNetToMedia.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ipNetToMedia.setNetAddress(inetAddress);
        ipNetToMedia.setPhysAddress(mac);
        ipNetToMedia.setNode(node);
        ipNetToMedia.setSourceIfIndex(Integer.valueOf(0));
        ipNetToMedia.setSourceNode(sourceNode);
        return ipNetToMedia;
    }

    public void increasePortCounter() {
        ++this.bridgePortCounter;
    }
}

