/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.protocol.UserDefinedProtocol;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeElement;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.enlinkd.model.CdpLink;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.model.IsIsElement;
import org.opennms.netmgt.enlinkd.model.IsIsLink;
import org.opennms.netmgt.enlinkd.model.LldpElement;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class TopologyPersister {
    private static final int BATCH_SIZE = 100;
    private GenericPersistenceAccessor genericPersistenceAccessor;
    private TopologyGenerator.ProgressCallback progressCallback;

    public TopologyPersister(GenericPersistenceAccessor genericPersistenceAccessor, TopologyGenerator.ProgressCallback progressCallback) {
        this.genericPersistenceAccessor = genericPersistenceAccessor;
        this.progressCallback = progressCallback;
    }

    public <E> void persist(E entity) {
        this.progressCallback.currentProgress("  Inserting %s:", entity.getClass().getSimpleName());
        this.genericPersistenceAccessor.save(entity);
        this.progressCallback.currentProgress("    Inserting of %s done.", entity.getClass().getSimpleName());
    }

    public <E> void persist(E ... elements) {
        this.persist(Arrays.asList(elements));
    }

    public <E> void persist(List<E> elements) {
        if (elements.size() < 1) {
            return;
        }
        this.progressCallback.currentProgress("  Inserting %s %ss:", elements.size(), elements.get(0).getClass().getSimpleName());
        for (int startBatch = 0; startBatch < elements.size(); startBatch += 100) {
            int endBatch = Math.min(startBatch + 100, elements.size());
            List<E> batch = elements.subList(startBatch, endBatch);
            this.genericPersistenceAccessor.saveAll(batch);
            this.progressCallback.currentProgress("    Inserting %s of %s %ss done.", endBatch, elements.size(), elements.get(0).getClass().getSimpleName());
        }
    }

    public void deleteTopology() {
        this.progressCallback.currentProgress("\nDeleting existing generated topology if present: ");
        List<Class> deleteOperations = Arrays.asList(CdpLink.class, IsIsLink.class, LldpLink.class, CdpElement.class, IsIsElement.class, LldpElement.class, OspfLink.class, BridgeBridgeLink.class, BridgeMacLink.class, BridgeElement.class, OnmsIpInterface.class, OnmsSnmpInterface.class, IpNetToMedia.class);
        for (Class clazz : deleteOperations) {
            this.deleteEntities(clazz);
        }
        this.deleteUserDefinedLinks();
        this.deleteNodes();
        this.deleteCategory();
    }

    private void deleteEntities(Class<?> clazz) {
        this.deleteEntities(clazz, String.format("SELECT e FROM %s e JOIN e.node n JOIN n.categories c WHERE c.name = '%s'", clazz.getSimpleName(), "GeneratedNode"));
    }

    private void deleteUserDefinedLinks() {
        this.deleteEntities(OnmsNode.class, String.format("SELECT l FROM UserDefinedLink l WHERE l.owner = '%s'", UserDefinedProtocol.OWNER));
    }

    private void deleteNodes() {
        this.deleteEntities(OnmsNode.class, String.format("SELECT n FROM OnmsNode n JOIN n.categories c WHERE c.name = '%s'", "GeneratedNode"));
    }

    private void deleteCategory() {
        this.deleteEntities(OnmsCategory.class, String.format("SELECT c FROM OnmsCategory c WHERE c.name = '%s'", "GeneratedNode"));
    }

    private <E> void deleteEntities(Class<?> clazz, String sql) {
        List entities = this.genericPersistenceAccessor.find(sql);
        this.genericPersistenceAccessor.deleteAll((Collection)entities);
        this.progressCallback.currentProgress("  %s %ss deleted.", entities.size(), clazz.getSimpleName());
    }
}

