/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.topology;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.enlinkd.generator.topology.PairGenerator;

public class RandomConnectedPairGenerator<E>
implements PairGenerator<E> {
    private final List<E> elements;
    private Random random = new Random(42L);

    public RandomConnectedPairGenerator(List<E> elements) {
        if (elements == null || elements.size() < 2) {
            throw new IllegalArgumentException("Need at least 2 elements in list to make a pair");
        }
        if (new HashSet<E>(elements).size() < elements.size()) {
            throw new IllegalArgumentException("List contains at least one duplicate");
        }
        this.elements = elements;
    }

    @Override
    public Pair<E, E> next() {
        E leftElement = this.getRandomElement(this.elements);
        E rightElement = this.getRandomElementButNotSame(this.elements, leftElement);
        return Pair.of(leftElement, rightElement);
    }

    private E getRandomElementButNotSame(List<E> elements, E notSame) {
        E value = this.getRandomElement(elements);
        while (value.equals(notSame)) {
            value = this.getRandomElement(elements);
        }
        return value;
    }

    private E getRandomElement(List<E> list) {
        return list.get(this.random.nextInt(list.size()));
    }
}

