/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.topology;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.enlinkd.generator.topology.PairGenerator;

public class LinkedPairGenerator<E>
implements PairGenerator<E> {
    private final List<E> elements;
    private final int lastIndexInList;
    private int indexLeft = -1;
    private int indexRight = 0;

    @Override
    public Pair<E, E> next() {
        this.compute();
        return Pair.of(this.elements.get(this.indexLeft), this.elements.get(this.indexRight));
    }

    public LinkedPairGenerator(List<E> elements) {
        if (elements == null || elements.size() < 2) {
            throw new IllegalArgumentException("Need at least 2 elements in list to make a pair");
        }
        this.elements = elements;
        this.lastIndexInList = elements.size() - 1;
    }

    private void compute() {
        this.indexLeft = this.next(this.indexLeft);
        this.indexRight = this.next(this.indexRight);
    }

    private int next(int i) {
        if (i == this.lastIndexInList) {
            return 0;
        }
        return ++i;
    }
}

