/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.protocol;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.enlinkd.generator.TopologyContext;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.enlinkd.generator.protocol.Protocol;
import org.opennms.enlinkd.generator.topology.PairGenerator;
import org.opennms.enlinkd.generator.util.InetAddressGenerator;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.model.OnmsNode;

public class OspfProtocol
extends Protocol<OspfElement> {
    private TopologyGenerator.Protocol protocol = TopologyGenerator.Protocol.ospf;
    private InetAddressGenerator inetAddressCreator = new InetAddressGenerator();

    public OspfProtocol(TopologySettings topologySettings, TopologyContext context) {
        super(topologySettings, context);
    }

    @Override
    public void createAndPersistProtocolSpecificEntities(List<OnmsNode> nodes) {
        List<OspfLink> links = this.createLinks(nodes);
        this.context.getTopologyPersister().persist(links);
    }

    private List<OspfLink> createLinks(List<OnmsNode> nodes) {
        PairGenerator<OnmsNode> pairs = this.createPairGenerator(nodes);
        ArrayList<OspfLink> links = new ArrayList<OspfLink>();
        for (int i = 0; i < this.topologySettings.getAmountLinks() / 2; ++i) {
            Pair<OnmsNode, OnmsNode> pair = pairs.next();
            OnmsNode sourceNode = (OnmsNode)pair.getLeft();
            OnmsNode targetNode = (OnmsNode)pair.getRight();
            InetAddress ospfIpAddr = this.inetAddressCreator.next();
            InetAddress ospfRemIpAddr = this.inetAddressCreator.next();
            OspfLink sourceLink = this.createLink(sourceNode, ospfIpAddr, ospfRemIpAddr, (Integer)this.nodeIfIndexes.get(sourceNode.getId()));
            links.add(sourceLink);
            OspfLink targetLink = this.createLink(targetNode, ospfRemIpAddr, ospfIpAddr, (Integer)this.nodeIfIndexes.get(targetNode.getId()));
            links.add(targetLink);
            this.context.currentProgress(String.format("Linked node %s with node %s", sourceNode.getLabel(), targetNode.getLabel()));
        }
        return links;
    }

    private OspfLink createLink(OnmsNode node, InetAddress ipAddress, InetAddress remoteAddress, int ifIndex) {
        OspfLink link = new OspfLink();
        link.setNode(node);
        link.setOspfIpAddr(ipAddress);
        link.setOspfRemIpAddr(remoteAddress);
        link.setOspfIpMask(this.inetAddressCreator.next());
        link.setOspfAddressLessIndex(Integer.valueOf(3));
        link.setOspfIfIndex(Integer.valueOf(ifIndex));
        link.setOspfRemRouterId(this.inetAddressCreator.next());
        link.setOspfRemAddressLessIndex(Integer.valueOf(3));
        link.setOspfLinkLastPollTime(new Date());
        return link;
    }

    @Override
    public TopologyGenerator.Protocol getProtocol() {
        return this.protocol;
    }
}

