/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.protocol;

import java.util.List;
import org.opennms.enlinkd.generator.TopologyContext;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.enlinkd.generator.protocol.Protocol;
import org.opennms.enlinkd.generator.protocol.bridge.BridgeBuilder;
import org.opennms.enlinkd.generator.protocol.bridge.BridgeBuilderContext;
import org.opennms.enlinkd.generator.util.InetAddressGenerator;
import org.opennms.enlinkd.generator.util.MacAddressGenerator;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.model.OnmsNode;

public class BridgeProtocol
extends Protocol<BridgeBridgeLink> {
    private static final int VLAN_ID = 1;
    private final MacAddressGenerator macGenerator = new MacAddressGenerator();
    private final InetAddressGenerator inetGenerator = new InetAddressGenerator();

    public BridgeProtocol(TopologySettings topologySettings, TopologyContext context) {
        super(topologySettings, context);
    }

    @Override
    protected void printProtocolSpecificMessage() {
        this.context.currentProgress("%nCreating %s topology with %s Nodes. Other settings are ignored since they not relevant for this topology", new Object[]{this.getProtocol(), this.topologySettings.getAmountNodes()});
    }

    @Override
    protected TopologySettings adoptAndVerifySettings(TopologySettings topologySettings) {
        int amountNodes;
        if (topologySettings.getAmountNodes() < 11) {
            amountNodes = 11;
        } else {
            amountNodes = topologySettings.getAmountNodes();
            int modulo = (amountNodes - 1) % 10;
            if (modulo != 0) {
                amountNodes += 10 - modulo;
            }
        }
        return TopologySettings.builder().amountNodes(amountNodes).amountSnmpInterfaces(0).amountIpInterfaces(0).amountLinks(0).amountElements(0).build();
    }

    @Override
    protected TopologyGenerator.Protocol getProtocol() {
        return TopologyGenerator.Protocol.bridge;
    }

    @Override
    protected void createAndPersistProtocolSpecificEntities(List<OnmsNode> nodes) {
        OnmsNode bridge0 = nodes.get(0);
        BridgeBuilderContext context = new BridgeBuilderContext(this.context.getTopologyPersister(), this.macGenerator, this.inetGenerator);
        BridgeBuilder bridge0B = new BridgeBuilder(bridge0, 0, context);
        this.createAndPersistProtocolSpecificEntities(nodes, bridge0B, bridge0, 0);
    }

    private void createAndPersistProtocolSpecificEntities(List<OnmsNode> nodes, BridgeBuilder root, OnmsNode gateway, int iteration) {
        int offset = iteration * 10;
        OnmsNode bridge1 = nodes.get(1 + offset);
        OnmsNode bridge2 = nodes.get(2 + offset);
        OnmsNode bridge3 = nodes.get(3 + offset);
        OnmsNode host4 = nodes.get(4 + offset);
        OnmsNode bridge5 = nodes.get(5 + offset);
        OnmsNode host6 = nodes.get(6 + offset);
        OnmsNode host7 = nodes.get(7 + offset);
        OnmsNode host8 = nodes.get(8 + offset);
        OnmsNode host9 = nodes.get(9 + offset);
        OnmsNode bridge10 = nodes.get(10 + offset);
        BridgeBuilder bridge1B = root.connectToNewBridge(bridge1, 11);
        BridgeBuilder bridge3B = root.connectToNewBridge(bridge3, 31);
        root.increasePortCounter();
        root.createAndPersistCloud(2, 2);
        root.increasePortCounter();
        root.createAndPersistBridgeMacLink(host4, 41, gateway);
        BridgeBuilder bridge5B = root.connectToNewBridge(bridge5, 51);
        BridgeBuilder bridge2B = bridge1B.connectToNewBridge(bridge2, 21);
        bridge1B.createAndPersistCloud(2, 2);
        bridge2B.increasePortCounter();
        bridge2B.createAndPersistBridgeMacLink(true, host6, 61, gateway);
        bridge2B.createAndPersistBridgeMacLink(false, host7, 71, gateway);
        bridge3B.increasePortCounter();
        bridge3B.createAndPersistBridgeMacLink(host8, null, gateway);
        bridge3B.increasePortCounter();
        bridge3B.createAndPersistBridgeMacLink(host9, null, gateway);
        root.connectToNewBridge(bridge10, 10);
        if (nodes.size() >= offset + 20) {
            this.createAndPersistProtocolSpecificEntities(nodes, bridge5B, gateway, iteration + 1);
        }
    }
}

