/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.protocol;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.enlinkd.generator.TopologyContext;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.enlinkd.generator.protocol.Protocol;
import org.opennms.enlinkd.generator.topology.PairGenerator;
import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.enlinkd.model.CdpLink;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpProtocol
extends Protocol<CdpElement> {
    private static final Logger LOG = LoggerFactory.getLogger(CdpProtocol.class);
    private TopologyGenerator.Protocol protocol = TopologyGenerator.Protocol.cdp;

    public CdpProtocol(TopologySettings topologySettings, TopologyContext context) {
        super(topologySettings, context);
    }

    @Override
    public void createAndPersistProtocolSpecificEntities(List<OnmsNode> nodes) {
        List<CdpElement> cdpElements = this.createCdpElements(nodes);
        this.context.getTopologyPersister().persist(cdpElements);
        List<CdpLink> links = this.createLinks(cdpElements);
        this.context.getTopologyPersister().persist(links);
    }

    private List<CdpElement> createCdpElements(List<OnmsNode> nodes) {
        ArrayList<CdpElement> cdpElements = new ArrayList<CdpElement>();
        for (int i = 0; i < this.topologySettings.getAmountElements(); ++i) {
            OnmsNode node = nodes.get(i);
            cdpElements.add(this.createCdpElement(node));
        }
        return cdpElements;
    }

    private CdpElement createCdpElement(OnmsNode node) {
        CdpElement cdpElement = new CdpElement();
        cdpElement.setNode(node);
        cdpElement.setCdpGlobalDeviceId("CdpElementForNode" + node.getId());
        cdpElement.setCdpGlobalRun(OspfElement.TruthValue.FALSE);
        cdpElement.setCdpNodeLastPollTime(new Date());
        return cdpElement;
    }

    private List<CdpLink> createLinks(List<CdpElement> cdpElements) {
        PairGenerator<CdpElement> pairs = this.createPairGenerator(cdpElements);
        ArrayList<CdpLink> links = new ArrayList<CdpLink>();
        for (int i = 0; i < this.topologySettings.getAmountLinks() / 2; ++i) {
            Pair<CdpElement, CdpElement> pair = pairs.next();
            CdpElement sourceElement = (CdpElement)pair.getLeft();
            CdpElement targetElement = (CdpElement)pair.getRight();
            int sourceIfIndex = (Integer)this.nodeIfIndexes.get(sourceElement.getNode().getId());
            int targetIfIndex = (Integer)this.nodeIfIndexes.get(targetElement.getNode().getId());
            CdpLink sourceLink = this.createCdpLink(sourceElement.getNode(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), targetElement.getCdpGlobalDeviceId(), sourceIfIndex);
            links.add(sourceLink);
            String targetCdpCacheDevicePort = sourceLink.getCdpInterfaceName();
            String targetCdpInterfaceName = sourceLink.getCdpCacheDevicePort();
            String targetCdpGlobalDeviceId = sourceElement.getCdpGlobalDeviceId();
            CdpLink targetLink = this.createCdpLink(targetElement.getNode(), targetCdpInterfaceName, targetCdpCacheDevicePort, targetCdpGlobalDeviceId, targetIfIndex);
            links.add(targetLink);
            this.context.currentProgress(String.format("Linked node %s with node %s", sourceElement.getNode().getLabel(), targetElement.getNode().getLabel()));
        }
        return links;
    }

    private CdpLink createCdpLink(OnmsNode node, String cdpInterfaceName, String cdpCacheDevicePort, String cdpCacheDeviceId, int ifIndex) {
        CdpLink link = new CdpLink();
        link.setCdpCacheDeviceId(cdpCacheDeviceId);
        link.setCdpInterfaceName(cdpInterfaceName);
        link.setCdpCacheDevicePort(cdpCacheDevicePort);
        link.setNode(node);
        link.setCdpCacheAddressType(CdpLink.CiscoNetworkProtocolType.chaos);
        link.setCdpCacheAddress("CdpCacheAddress");
        link.setCdpCacheDeviceIndex(Integer.valueOf(33));
        link.setCdpCacheDevicePlatform("CdpCacheDevicePlatform");
        link.setCdpCacheIfIndex(Integer.valueOf(ifIndex));
        link.setCdpCacheVersion("CdpCacheVersion");
        link.setCdpLinkLastPollTime(new Date());
        return link;
    }

    @Override
    public TopologyGenerator.Protocol getProtocol() {
        return this.protocol;
    }
}

