/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.protocol;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.enlinkd.generator.TopologyContext;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.enlinkd.generator.topology.LinkedPairGenerator;
import org.opennms.enlinkd.generator.topology.PairGenerator;
import org.opennms.enlinkd.generator.topology.RandomConnectedPairGenerator;
import org.opennms.enlinkd.generator.topology.UndirectedPairGenerator;
import org.opennms.enlinkd.generator.util.InetAddressGenerator;
import org.opennms.enlinkd.generator.util.RandomUtil;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;

public abstract class Protocol<Element> {
    final TopologySettings topologySettings;
    final TopologyContext context;
    private final RandomUtil random = new RandomUtil();
    final Map<Integer, Integer> nodeIfIndexes = new HashMap<Integer, Integer>();

    public Protocol(TopologySettings topologySettings, TopologyContext context) {
        this.topologySettings = topologySettings;
        this.context = context;
    }

    public void createAndPersistNetwork() {
        this.context.currentProgress("%nCreating %s %s topology with %s Nodes, %s Elements, %s Links, %s SnmpInterfaces, %s IpInterfaces:", new Object[]{this.topologySettings.getTopology(), this.getProtocol(), this.topologySettings.getAmountNodes(), this.topologySettings.getAmountElements(), this.topologySettings.getAmountElements(), this.topologySettings.getAmountSnmpInterfaces(), this.topologySettings.getAmountIpInterfaces()});
        OnmsCategory category = this.createCategory();
        this.context.getTopologyPersister().persist(category);
        List<OnmsNode> nodes = this.createNodes(this.topologySettings.getAmountNodes(), category);
        this.context.getTopologyPersister().persist(nodes);
        List<OnmsSnmpInterface> snmpInterfaces = this.createSnmpInterfaces(nodes);
        this.context.getTopologyPersister().persist(snmpInterfaces);
        List<OnmsIpInterface> ipInterfaces = this.createIpInterfaces(snmpInterfaces);
        this.context.getTopologyPersister().persist(ipInterfaces);
        this.createAndPersistProtocolSpecificEntities(nodes);
    }

    protected abstract void createAndPersistProtocolSpecificEntities(List<OnmsNode> var1);

    protected abstract TopologyGenerator.Protocol getProtocol();

    private OnmsCategory createCategory() {
        OnmsCategory category = new OnmsCategory();
        category.setName("GeneratedNode");
        return category;
    }

    private OnmsMonitoringLocation createMonitoringLocation() {
        OnmsMonitoringLocation location = new OnmsMonitoringLocation();
        location.setLocationName("Default");
        location.setMonitoringArea("localhost");
        return location;
    }

    protected List<OnmsNode> createNodes(int amountNodes, OnmsCategory category) {
        OnmsMonitoringLocation location = this.createMonitoringLocation();
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        for (int i = 0; i < amountNodes; ++i) {
            nodes.add(this.createNode(i, location, category));
        }
        return nodes;
    }

    protected OnmsNode createNode(int count, OnmsMonitoringLocation location, OnmsCategory category) {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(count));
        node.setLabel("Node" + count);
        node.setLocation(location);
        node.addCategory(category);
        node.setType(OnmsNode.NodeType.ACTIVE);
        node.setForeignSource("fs" + count);
        node.setForeignId("fid" + count);
        return node;
    }

    protected List<OnmsSnmpInterface> createSnmpInterfaces(List<OnmsNode> nodes) {
        ArrayList<OnmsSnmpInterface> interfaces = new ArrayList<OnmsSnmpInterface>();
        for (int i = 0; i < this.topologySettings.getAmountSnmpInterfaces(); ++i) {
            interfaces.add(this.createSnmpInterface(i, this.random.getRandom(nodes)));
        }
        return interfaces;
    }

    private OnmsSnmpInterface createSnmpInterface(int ifIndex, OnmsNode node) {
        OnmsSnmpInterface onmsSnmpInterface = new OnmsSnmpInterface();
        onmsSnmpInterface.setId(Integer.valueOf(node.getId() * this.topologySettings.getAmountSnmpInterfaces() + ifIndex));
        onmsSnmpInterface.setNode(node);
        onmsSnmpInterface.setIfIndex(Integer.valueOf(ifIndex));
        onmsSnmpInterface.setIfType(Integer.valueOf(4));
        onmsSnmpInterface.setIfSpeed(Long.valueOf(5L));
        onmsSnmpInterface.setIfAdminStatus(Integer.valueOf(6));
        onmsSnmpInterface.setIfOperStatus(Integer.valueOf(7));
        onmsSnmpInterface.setLastCapsdPoll(new Date());
        onmsSnmpInterface.setLastSnmpPoll(new Date());
        this.nodeIfIndexes.computeIfAbsent(node.getId(), key -> ifIndex);
        return onmsSnmpInterface;
    }

    protected List<OnmsIpInterface> createIpInterfaces(List<OnmsSnmpInterface> snmps) {
        ArrayList<OnmsIpInterface> interfaces = new ArrayList<OnmsIpInterface>();
        InetAddressGenerator inetGenerator = new InetAddressGenerator();
        for (int i = 0; i < this.topologySettings.getAmountIpInterfaces(); ++i) {
            interfaces.add(this.createIpInterface(this.random.getRandom(snmps), inetGenerator.next()));
        }
        return interfaces;
    }

    private OnmsIpInterface createIpInterface(OnmsSnmpInterface snmp, InetAddress inetAddress) {
        OnmsIpInterface ip = new OnmsIpInterface();
        ip.setId(snmp.getId());
        ip.setSnmpInterface(snmp);
        ip.setIpLastCapsdPoll(new Date());
        ip.setNode(snmp.getNode());
        ip.setIpAddress(inetAddress);
        return ip;
    }

    protected <E> PairGenerator<E> createPairGenerator(List<E> elements) {
        if (TopologyGenerator.Topology.complete == this.topologySettings.getTopology()) {
            return new UndirectedPairGenerator<E>(elements);
        }
        if (TopologyGenerator.Topology.ring == this.topologySettings.getTopology()) {
            return new LinkedPairGenerator<E>(elements);
        }
        if (TopologyGenerator.Topology.random == this.topologySettings.getTopology()) {
            return new RandomConnectedPairGenerator<E>(elements);
        }
        throw new IllegalArgumentException("unknown topology: " + (Object)((Object)this.topologySettings.getTopology()));
    }
}

