/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.opennms.core.utils.InsufficientInformationException;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

@EventListener(name="enlinkd")
public final class EventProcessor {
    private EnhancedLinkd m_linkd;

    public void setLinkd(EnhancedLinkd linkd) {
        this.m_linkd = linkd;
    }

    public EnhancedLinkd getLinkd() {
        return this.m_linkd;
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAdded(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId((Event)event);
        this.m_linkd.addNode(event.getNodeid().intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId((Event)event);
        this.m_linkd.deleteNode(event.getNodeid().intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedService")
    public void handleNodeGainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId((Event)event);
        EventUtils.checkService((Event)event);
        if (event.getService().equals("SNMP")) {
            this.m_linkd.scheduleNodeCollection(event.getNodeid().intValue());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeLostService")
    public void handleNodeLostService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId((Event)event);
        EventUtils.checkService((Event)event);
        if (event.getService().equals("SNMP")) {
            this.m_linkd.suspendNodeCollection(event.getNodeid().intValue());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeRegainedService")
    public void handleRegainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId((Event)event);
        EventUtils.checkService((Event)event);
        if (event.getService().equals("SNMP")) {
            this.m_linkd.wakeUpNodeCollection(event.getNodeid().intValue());
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/forceRescan")
    public void handleForceRescan(Event e) {
        this.m_linkd.rescheduleNodeCollection(new Long(e.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadDaemonConfig(Event e) {
        List parmCollection = e.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Enlinkd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            this.m_linkd.reloadConfig();
            break;
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadTopology")
    public void handleReloadTopology(Event e) {
        String topologyNamespace = EventUtils.getParm((Event)e, (String)"namespace");
        if (topologyNamespace == null || "all".equalsIgnoreCase(topologyNamespace) || "nodes".equalsIgnoreCase(topologyNamespace)) {
            this.m_linkd.reloadTopology();
        }
    }
}

