/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.collect.Table;
import java.util.Map;
import org.opennms.netmgt.enlinkd.common.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.CdpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.CdpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class CdpOnmsTopologyUpdater
extends TopologyUpdater {
    private final CdpTopologyService m_cdpTopologyService;

    public static CdpOnmsTopologyUpdater clone(CdpOnmsTopologyUpdater bpu) {
        CdpOnmsTopologyUpdater update = new CdpOnmsTopologyUpdater(bpu.getTopologyDao(), bpu.getCdpTopologyService(), bpu.getNodeTopologyService());
        update.setRunned(bpu.isRunned());
        update.setTopology(bpu.getTopology());
        return update;
    }

    public static OnmsTopologyPort create(OnmsTopologyVertex vertex, CdpLinkTopologyEntity cdpLink, SnmpInterfaceTopologyEntity snmpiface) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)cdpLink.getId().toString(), (OnmsTopologyVertex)vertex, (Integer)cdpLink.getCdpCacheIfIndex());
        port.setIfindex(cdpLink.getCdpCacheIfIndex());
        port.setIfname(cdpLink.getCdpInterfaceName());
        port.setAddr(Topology.getAddress((CdpLinkTopologyEntity)cdpLink));
        port.setToolTipText(Topology.getPortTextString((String)vertex.getLabel(), (Integer)port.getIfindex(), (String)port.getAddr(), (SnmpInterfaceTopologyEntity)snmpiface));
        return port;
    }

    public CdpOnmsTopologyUpdater(OnmsTopologyDao topologyDao, CdpTopologyService cdpTopologyService, NodeTopologyService nodeTopologyService) {
        super((TopologyService)cdpTopologyService, topologyDao, nodeTopologyService);
        this.m_cdpTopologyService = cdpTopologyService;
    }

    public String getName() {
        return "CdpTopologyUpdater";
    }

    public OnmsTopology buildTopology() {
        Map nodeMap = this.getNodeMap();
        Map ipMap = this.getIpPrimaryMap();
        Table nodeToOnmsSnmpTable = this.getSnmpInterfaceTable();
        OnmsTopology topology = new OnmsTopology();
        for (CdpElementTopologyEntity element : this.m_cdpTopologyService.findAllCdpElements()) {
            topology.getVertices().add(CdpOnmsTopologyUpdater.create((NodeTopologyEntity)((NodeTopologyEntity)nodeMap.get(element.getNodeId())), (IpInterfaceTopologyEntity)((IpInterfaceTopologyEntity)ipMap.get(element.getNodeId()))));
        }
        for (TopologyConnection pair : this.m_cdpTopologyService.match()) {
            topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getDefaultEdgeId((int)((CdpLinkTopologyEntity)pair.getLeft()).getId(), (int)((CdpLinkTopologyEntity)pair.getRight()).getId()), (OnmsTopologyPort)CdpOnmsTopologyUpdater.create(topology.getVertex(((CdpLinkTopologyEntity)pair.getLeft()).getNodeIdAsString()), (CdpLinkTopologyEntity)pair.getLeft(), (SnmpInterfaceTopologyEntity)nodeToOnmsSnmpTable.get((Object)((CdpLinkTopologyEntity)pair.getLeft()).getNodeId(), (Object)((CdpLinkTopologyEntity)pair.getLeft()).getCdpCacheIfIndex())), (OnmsTopologyPort)CdpOnmsTopologyUpdater.create(topology.getVertex(((CdpLinkTopologyEntity)pair.getRight()).getNodeIdAsString()), (CdpLinkTopologyEntity)pair.getRight(), (SnmpInterfaceTopologyEntity)nodeToOnmsSnmpTable.get((Object)((CdpLinkTopologyEntity)pair.getRight()).getNodeId(), (Object)((CdpLinkTopologyEntity)pair.getRight()).getCdpCacheIfIndex()))));
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() {
        return CdpOnmsTopologyUpdater.create((ProtocolSupported)ProtocolSupported.CDP);
    }

    public CdpTopologyService getCdpTopologyService() {
        return this.m_cdpTopologyService;
    }
}

