/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.NodeCollector;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.snmp.LldpLocPortGetter;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryLldp
extends NodeCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryLldp.class);
    private static final String DW_SYSOID = ".1.3.6.1.4.1.7262.2.4";
    private static final String DW_NULL_CHASSIS_ID = "cf";
    private static final String DW_NULL_SYSOID_ID = "NuDesign";
    private final LldpTopologyService m_lldpTopologyService;

    public NodeDiscoveryLldp(LldpTopologyService lldpTopologyService, LocationAwareSnmpClient locationAwareSnmpClient, long interval, long initial, Node node) {
        super(locationAwareSnmpClient, interval, initial, node);
        this.m_lldpTopologyService = lldpTopologyService;
    }

    @Override
    protected void collect() {
        Date now = new Date();
        LldpLocalGroupTracker lldpLocalGroup = new LldpLocalGroupTracker();
        SnmpAgentConfig peer = this.getSnmpAgentConfig();
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)lldpLocalGroup).withDescription("lldpLocalGroup").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: LLDP_MIB not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: LLDP_MIB not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        if (lldpLocalGroup.getLldpLocChassisid() == null) {
            LOG.info("run: node[{}]: LLDP_MIB not supported", (Object)this.getNodeId());
            return;
        }
        LOG.debug("run: node[{}]: lldp identifier : {}", (Object)this.getNodeId(), (Object)lldpLocalGroup.getLldpElement().getLldpChassisId());
        this.m_lldpTopologyService.store(this.getNodeId(), lldpLocalGroup.getLldpElement());
        if (this.getSysoid() == null || this.getSysoid().equals(DW_SYSOID)) {
            if (lldpLocalGroup.getLldpLocChassisid().toHexString().equals(DW_NULL_CHASSIS_ID) && lldpLocalGroup.getLldpLocChassisidSubType() == LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT.getValue()) {
                LOG.info("run: node[{}]: address {}. lldp identifier : {}. lldp not active for Dragon Wave Device.", new Object[]{this.getNodeId(), this.getPrimaryIpAddressString(), lldpLocalGroup.getLldpElement()});
                return;
            }
            if (lldpLocalGroup.getLldpLocSysname().equals(DW_NULL_SYSOID_ID)) {
                LOG.info("run: node[{}]: lldp identifier : {}. lldp not active for Dragon Wave Device.", (Object)this.getNodeId(), (Object)lldpLocalGroup.getLldpElement());
                return;
            }
        }
        final ArrayList links = new ArrayList();
        LldpRemTableTracker lldpRemTable = new LldpRemTableTracker(){

            public void processLldpRemRow(LldpRemTableTracker.LldpRemRow row) {
                links.add(row.getLldpLink());
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)lldpRemTable).withDescription("lldpRemTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        LldpLocPortGetter lldpLocPort = new LldpLocPortGetter(peer, this.getLocationAwareSnmpClient(), this.getLocation(), Integer.valueOf(this.getNodeId()));
        for (LldpLink link : links) {
            this.m_lldpTopologyService.store(this.getNodeId(), lldpLocPort.getLldpLink(link));
        }
        this.m_lldpTopologyService.reconcile(this.getNodeId(), now);
    }

    @Override
    public String getName() {
        return "NodeDiscoveryLldp";
    }
}

