/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.collect.Table;
import java.util.Map;
import org.opennms.netmgt.enlinkd.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IsIsElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IsIsLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.IsisTopologyService;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class IsisOnmsTopologyUpdater
extends TopologyUpdater {
    private final IsisTopologyService m_isisTopologyService;

    public static IsisOnmsTopologyUpdater clone(IsisOnmsTopologyUpdater bpu) {
        IsisOnmsTopologyUpdater update = new IsisOnmsTopologyUpdater(bpu.getTopologyDao(), bpu.getIsisTopologyService(), bpu.getNodeTopologyService());
        update.setRunned(bpu.isRunned());
        update.setTopology(bpu.getTopology());
        return update;
    }

    public static OnmsTopologyPort create(OnmsTopologyVertex source, IsIsLinkTopologyEntity sourceLink, IsIsLinkTopologyEntity targetLink, SnmpInterfaceTopologyEntity snmpiface) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)sourceLink.getId().toString(), (OnmsTopologyVertex)source, (Integer)targetLink.getIsisISAdjIndex());
        port.setIfindex(sourceLink.getIsisCircIfIndex());
        if (snmpiface != null) {
            port.setIfname(snmpiface.getIfName());
        }
        port.setIfname(sourceLink.getIsisCircIfIndex().toString());
        port.setAddr(Topology.getRemoteAddress((IsIsLinkTopologyEntity)targetLink));
        port.setToolTipText(Topology.getPortTextString((String)source.getLabel(), (Integer)port.getIfindex(), (String)port.getAddr(), (SnmpInterfaceTopologyEntity)snmpiface));
        return port;
    }

    public IsisOnmsTopologyUpdater(OnmsTopologyDao topologyDao, IsisTopologyService isisTopologyService, NodeTopologyService nodeTopologyService) {
        super((TopologyService)isisTopologyService, topologyDao, nodeTopologyService);
        this.m_isisTopologyService = isisTopologyService;
    }

    @Override
    public String getName() {
        return "IsIsTopologyUpdater";
    }

    @Override
    public OnmsTopology buildTopology() {
        Map<Integer, NodeTopologyEntity> nodeMap = this.getNodeMap();
        Map<Integer, IpInterfaceTopologyEntity> ipMap = this.getIpPrimaryMap();
        Table<Integer, Integer, SnmpInterfaceTopologyEntity> nodeToOnmsSnmpTable = this.getSnmpInterfaceTable();
        OnmsTopology topology = new OnmsTopology();
        for (IsIsElementTopologyEntity element : this.m_isisTopologyService.findAllIsIsElements()) {
            topology.getVertices().add(IsisOnmsTopologyUpdater.create(nodeMap.get(element.getNodeId()), ipMap.get(element.getNodeId())));
        }
        for (TopologyConnection pair : this.m_isisTopologyService.match()) {
            topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getDefaultEdgeId((int)((IsIsLinkTopologyEntity)pair.getLeft()).getId(), (int)((IsIsLinkTopologyEntity)pair.getRight()).getId()), (OnmsTopologyPort)IsisOnmsTopologyUpdater.create(topology.getVertex(((IsIsLinkTopologyEntity)pair.getLeft()).getNodeIdAsString()), (IsIsLinkTopologyEntity)pair.getLeft(), (IsIsLinkTopologyEntity)pair.getRight(), (SnmpInterfaceTopologyEntity)nodeToOnmsSnmpTable.get((Object)((IsIsLinkTopologyEntity)pair.getLeft()).getNodeId(), (Object)((IsIsLinkTopologyEntity)pair.getLeft()).getIsisCircIfIndex())), (OnmsTopologyPort)IsisOnmsTopologyUpdater.create(topology.getVertex(((IsIsLinkTopologyEntity)pair.getRight()).getNodeIdAsString()), (IsIsLinkTopologyEntity)pair.getRight(), (IsIsLinkTopologyEntity)pair.getLeft(), (SnmpInterfaceTopologyEntity)nodeToOnmsSnmpTable.get((Object)((IsIsLinkTopologyEntity)pair.getRight()).getNodeId(), (Object)((IsIsLinkTopologyEntity)pair.getRight()).getIsisCircIfIndex()))));
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() {
        return IsisOnmsTopologyUpdater.create(ProtocolSupported.ISIS);
    }

    public IsisTopologyService getIsisTopologyService() {
        return this.m_isisTopologyService;
    }
}

