/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.enlinkd.BridgeOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.CdpOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.DiscoveryBridgeDomains;
import org.opennms.netmgt.enlinkd.IsisOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.LldpOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.NodeCollector;
import org.opennms.netmgt.enlinkd.NodeDiscoveryBridge;
import org.opennms.netmgt.enlinkd.NodeDiscoveryCdp;
import org.opennms.netmgt.enlinkd.NodeDiscoveryIpNetToMedia;
import org.opennms.netmgt.enlinkd.NodeDiscoveryIsis;
import org.opennms.netmgt.enlinkd.NodeDiscoveryLldp;
import org.opennms.netmgt.enlinkd.NodeDiscoveryOspf;
import org.opennms.netmgt.enlinkd.NodesOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.OspfOnmsTopologyUpdater;
import org.opennms.netmgt.enlinkd.TopologyUpdater;
import org.opennms.netmgt.enlinkd.api.ReloadableTopologyDaemon;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.CdpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.IpNetToMediaTopologyService;
import org.opennms.netmgt.enlinkd.service.api.IsisTopologyService;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EnhancedLinkd
extends AbstractServiceDaemon
implements ReloadableTopologyDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedLinkd.class);
    private static final String LOG_PREFIX = "enlinkd";
    private LegacyScheduler m_scheduler;
    private NodeTopologyService m_queryMgr;
    private BridgeTopologyService m_bridgeTopologyService;
    private CdpTopologyService m_cdpTopologyService;
    private IsisTopologyService m_isisTopologyService;
    private IpNetToMediaTopologyService m_ipNetToMediaTopologyService;
    private LldpTopologyService m_lldpTopologyService;
    private OspfTopologyService m_ospfTopologyService;
    private EnhancedLinkdConfig m_linkdConfig;
    private Map<Integer, List<NodeCollector>> m_nodes = new HashMap<Integer, List<NodeCollector>>();
    @Autowired
    private LocationAwareSnmpClient m_locationAwareSnmpClient;
    @Autowired
    private NodesOnmsTopologyUpdater m_nodesTopologyUpdater;
    @Autowired
    private BridgeOnmsTopologyUpdater m_bridgeTopologyUpdater;
    @Autowired
    private CdpOnmsTopologyUpdater m_cdpTopologyUpdater;
    @Autowired
    private LldpOnmsTopologyUpdater m_lldpTopologyUpdater;
    @Autowired
    private IsisOnmsTopologyUpdater m_isisTopologyUpdater;
    @Autowired
    private OspfOnmsTopologyUpdater m_ospfTopologyUpdater;
    @Autowired
    private DiscoveryBridgeDomains m_discoveryBridgeDomains;

    public EnhancedLinkd() {
        super(LOG_PREFIX);
    }

    protected void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        try {
            LOG.info("init: Creating EnhancedLinkd scheduler");
            this.m_scheduler = new LegacyScheduler("EnhancedLinkd", this.m_linkdConfig.getThreads());
        }
        catch (RuntimeException e) {
            LOG.error("init: Failed to create EnhancedLinkd scheduler", (Throwable)e);
            throw e;
        }
        LOG.debug("init: Loading nodes.....");
        for (Node node : this.m_queryMgr.findAllSnmpNode()) {
            this.m_nodes.put(node.getNodeId(), this.scheduleCollectionForNode(node));
        }
        LOG.debug("init: Nodes loaded.");
        LOG.debug("init: Loading Bridge Topology.....");
        this.m_bridgeTopologyService.load();
        LOG.debug("init: Bridge Topology loaded.");
        this.scheduleAndRegisterOnmsTopologyUpdater(this.m_nodesTopologyUpdater);
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            this.scheduleDiscoveryBridgeDomain();
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_bridgeTopologyUpdater);
        }
        if (this.m_linkdConfig.useCdpDiscovery()) {
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_cdpTopologyUpdater);
        }
        if (this.m_linkdConfig.useLldpDiscovery()) {
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_lldpTopologyUpdater);
        }
        if (this.m_linkdConfig.useIsisDiscovery()) {
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_isisTopologyUpdater);
        }
        if (this.m_linkdConfig.useOspfDiscovery()) {
            this.scheduleAndRegisterOnmsTopologyUpdater(this.m_ospfTopologyUpdater);
        }
    }

    public void unscheduleAndUnregisterOnmsTopologyUpdater(TopologyUpdater onmsTopologyUpdater) {
        LOG.info("unscheduleOnmsTopologyUpdater: UnScheduling {}", (Object)onmsTopologyUpdater.getInfo());
        onmsTopologyUpdater.unschedule();
        onmsTopologyUpdater.unregister();
    }

    public void scheduleAndRegisterOnmsTopologyUpdater(TopologyUpdater onmsTopologyUpdater) {
        onmsTopologyUpdater.setScheduler(this.m_scheduler);
        onmsTopologyUpdater.setPollInterval(this.m_linkdConfig.getTopologyInterval());
        onmsTopologyUpdater.setInitialSleepTime(0L);
        LOG.info("scheduleOnmsTopologyUpdater: Scheduling {}", (Object)onmsTopologyUpdater.getInfo());
        onmsTopologyUpdater.schedule();
        onmsTopologyUpdater.register();
    }

    public void unscheduleDiscoveryBridgeDomain() {
        LOG.info("unscheduleDiscoveryBridgeDomain: Scheduling {}", (Object)this.m_discoveryBridgeDomains.getInfo());
        this.m_discoveryBridgeDomains.unschedule();
    }

    public void scheduleDiscoveryBridgeDomain() {
        this.m_discoveryBridgeDomains.setScheduler(this.m_scheduler);
        this.m_discoveryBridgeDomains.setPollInterval(this.m_linkdConfig.getBridgeTopologyInterval());
        this.m_discoveryBridgeDomains.setInitialSleepTime(this.m_linkdConfig.getBridgeTopologyInterval() + this.m_linkdConfig.getInitialSleepTime());
        this.m_discoveryBridgeDomains.setMaxthreads(this.m_linkdConfig.getDiscoveryBridgeThreads());
        LOG.info("scheduleDiscoveryBridgeDomain: Scheduling {}", (Object)this.m_discoveryBridgeDomains.getInfo());
        this.m_discoveryBridgeDomains.schedule();
    }

    private List<NodeCollector> scheduleCollectionForNode(Node node) {
        ArrayList<NodeCollector> colls = new ArrayList<NodeCollector>();
        if (this.m_linkdConfig.useLldpDiscovery()) {
            LOG.debug("getSnmpCollections: adding Lldp: {}", (Object)node);
            colls.add(new NodeDiscoveryLldp(this.m_lldpTopologyService, this.m_locationAwareSnmpClient, this.m_linkdConfig.getRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), node));
        }
        if (this.m_linkdConfig.useCdpDiscovery()) {
            LOG.debug("getSnmpCollections: adding Cdp: {}", (Object)node);
            colls.add(new NodeDiscoveryCdp(this.m_cdpTopologyService, this.m_locationAwareSnmpClient, this.m_linkdConfig.getRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), node));
        }
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            LOG.debug("getSnmpCollections: adding IpNetToMedia: {}", (Object)node);
            colls.add(new NodeDiscoveryIpNetToMedia(this.m_ipNetToMediaTopologyService, this.m_locationAwareSnmpClient, this.m_linkdConfig.getRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), node));
            LOG.debug("getSnmpCollections: adding Bridge: {}", (Object)node);
            colls.add(new NodeDiscoveryBridge(this.m_bridgeTopologyService, this.m_linkdConfig.getMaxBft(), this.m_locationAwareSnmpClient, this.m_linkdConfig.getRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), node));
        }
        if (this.m_linkdConfig.useOspfDiscovery()) {
            LOG.debug("getSnmpCollections: adding Ospf: {}", (Object)node);
            colls.add(new NodeDiscoveryOspf(this.m_ospfTopologyService, this.m_locationAwareSnmpClient, this.m_linkdConfig.getRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), node));
        }
        if (this.m_linkdConfig.useIsisDiscovery()) {
            LOG.debug("getSnmpCollections: adding Is-Is: {}", (Object)node);
            colls.add(new NodeDiscoveryIsis(this.m_isisTopologyService, this.m_locationAwareSnmpClient, this.m_linkdConfig.getRescanInterval(), this.m_linkdConfig.getInitialSleepTime(), node));
        }
        for (NodeCollector coll : colls) {
            LOG.debug("ScheduleCollectionForNode: Scheduling {}", (Object)coll.getInfo());
            coll.setScheduler(this.m_scheduler);
            coll.schedule();
        }
        return colls;
    }

    protected synchronized void onStart() {
        this.m_scheduler.start();
    }

    protected synchronized void onStop() {
        this.m_scheduler.stop();
        this.m_scheduler = null;
    }

    protected synchronized void onPause() {
        this.m_scheduler.pause();
    }

    protected synchronized void onResume() {
        this.m_scheduler.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleNodeCollection(int nodeid) {
        if (this.m_nodes.containsKey(nodeid)) {
            LOG.debug("scheduleNodeCollection: node:[{}], node Collection already Scheduled ", (Object)nodeid);
            return false;
        }
        LOG.debug("scheduleNodeCollection: Loading node {} from database", (Object)nodeid);
        Node node = this.m_queryMgr.getSnmpNode(nodeid);
        if (node == null) {
            LOG.warn("scheduleNodeCollection: Failed to get linkable node from database with ID {}. Exiting", (Object)nodeid);
            return false;
        }
        Map<Integer, List<NodeCollector>> map = this.m_nodes;
        synchronized (map) {
            this.m_nodes.put(node.getNodeId(), this.scheduleCollectionForNode(node));
        }
        return true;
    }

    public boolean runSingleSnmpCollection(int nodeId) {
        boolean allready = true;
        if (!this.m_nodes.containsKey(nodeId)) {
            return false;
        }
        for (NodeCollector snmpColl : this.m_nodes.get(nodeId)) {
            if (!snmpColl.isReady()) {
                allready = false;
                continue;
            }
            snmpColl.collect();
        }
        return allready;
    }

    public void runDiscoveryBridgeDomains() {
        this.m_discoveryBridgeDomains.runDiscovery();
    }

    public void forceTopologyUpdaterRun(ProtocolSupported proto) {
        switch (proto) {
            case CDP: {
                if (!this.m_linkdConfig.useCdpDiscovery()) break;
                this.m_cdpTopologyUpdater.forceRun();
                break;
            }
            case LLDP: {
                if (!this.m_linkdConfig.useLldpDiscovery()) break;
                this.m_lldpTopologyUpdater.forceRun();
                break;
            }
            case ISIS: {
                if (!this.m_linkdConfig.useIsisDiscovery()) break;
                this.m_isisTopologyUpdater.forceRun();
                break;
            }
            case OSPF: {
                if (!this.m_linkdConfig.useOspfDiscovery()) break;
                this.m_ospfTopologyUpdater.forceRun();
                break;
            }
            case BRIDGE: {
                if (!this.m_linkdConfig.useBridgeDiscovery()) break;
                this.m_bridgeTopologyUpdater.forceRun();
                break;
            }
            case NODES: {
                this.m_nodesTopologyUpdater.forceRun();
                break;
            }
        }
    }

    public void runTopologyUpdater(ProtocolSupported proto) {
        switch (proto) {
            case CDP: {
                if (!this.m_linkdConfig.useCdpDiscovery()) break;
                this.m_cdpTopologyUpdater.runDiscovery();
                break;
            }
            case LLDP: {
                if (!this.m_linkdConfig.useLldpDiscovery()) break;
                this.m_lldpTopologyUpdater.runDiscovery();
                break;
            }
            case ISIS: {
                if (!this.m_linkdConfig.useIsisDiscovery()) break;
                this.m_isisTopologyUpdater.runDiscovery();
                break;
            }
            case OSPF: {
                if (!this.m_linkdConfig.useOspfDiscovery()) break;
                this.m_ospfTopologyUpdater.runDiscovery();
                break;
            }
            case BRIDGE: {
                if (!this.m_linkdConfig.useBridgeDiscovery()) break;
                this.m_bridgeTopologyUpdater.runDiscovery();
                break;
            }
            case NODES: {
                this.m_nodesTopologyUpdater.runDiscovery();
                break;
            }
        }
    }

    public DiscoveryBridgeDomains getDiscoveryBridgeDomains() {
        return this.m_discoveryBridgeDomains;
    }

    void wakeUpNodeCollection(int nodeid) {
        if (!this.m_nodes.containsKey(nodeid)) {
            LOG.warn("wakeUpNodeCollection: node not found during scheduling with ID {}", (Object)nodeid);
            this.scheduleNodeCollection(nodeid);
            return;
        }
        this.m_nodes.get(nodeid).stream().forEach(collection -> collection.wakeUp());
    }

    public void addNode(int intValue) {
        this.m_queryMgr.updatesAvailable();
    }

    void deleteNode(int nodeid) {
        LOG.info("deleteNode: deleting LinkableNode for node {}", (Object)nodeid);
        this.unscheduleNodeCollection(nodeid);
        try {
            this.m_bridgeTopologyService.delete(nodeid);
        }
        catch (BridgeTopologyException e) {
            LOG.error("deleteNode: {}", (Object)e.getMessage());
        }
        this.m_cdpTopologyService.delete(nodeid);
        this.m_isisTopologyService.delete(nodeid);
        this.m_lldpTopologyService.delete(nodeid);
        this.m_ospfTopologyService.delete(nodeid);
        this.m_ipNetToMediaTopologyService.delete(nodeid);
        this.m_queryMgr.updatesAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unscheduleNodeCollection(int nodeid) {
        Map<Integer, List<NodeCollector>> map = this.m_nodes;
        synchronized (map) {
            if (this.m_nodes.containsKey(nodeid)) {
                this.m_nodes.remove(nodeid).stream().forEach(coll -> coll.unschedule());
            }
        }
    }

    void rescheduleNodeCollection(int nodeid) {
        LOG.info("rescheduleNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        this.unscheduleNodeCollection(nodeid);
        this.scheduleNodeCollection(nodeid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspendNodeCollection(int nodeid) {
        LOG.info("suspendNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        Map<Integer, List<NodeCollector>> map = this.m_nodes;
        synchronized (map) {
            if (this.m_nodes.containsKey(nodeid)) {
                this.m_nodes.get(nodeid).stream().forEach(coll -> coll.suspend());
            }
        }
    }

    public NodeTopologyService getQueryManager() {
        return this.m_queryMgr;
    }

    public void setQueryManager(NodeTopologyService queryMgr) {
        this.m_queryMgr = queryMgr;
    }

    public LegacyScheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public EnhancedLinkdConfig getLinkdConfig() {
        return this.m_linkdConfig;
    }

    public void setLinkdConfig(EnhancedLinkdConfig config) {
        this.m_linkdConfig = config;
    }

    public String getSource() {
        return LOG_PREFIX;
    }

    public LocationAwareSnmpClient getLocationAwareSnmpClient() {
        return this.m_locationAwareSnmpClient;
    }

    public BridgeTopologyService getBridgeTopologyService() {
        return this.m_bridgeTopologyService;
    }

    public void setBridgeTopologyService(BridgeTopologyService bridgeTopologyService) {
        this.m_bridgeTopologyService = bridgeTopologyService;
    }

    public CdpTopologyService getCdpTopologyService() {
        return this.m_cdpTopologyService;
    }

    public void setCdpTopologyService(CdpTopologyService cdpTopologyService) {
        this.m_cdpTopologyService = cdpTopologyService;
    }

    public IsisTopologyService getIsisTopologyService() {
        return this.m_isisTopologyService;
    }

    public void setIsisTopologyService(IsisTopologyService isisTopologyService) {
        this.m_isisTopologyService = isisTopologyService;
    }

    public LldpTopologyService getLldpTopologyService() {
        return this.m_lldpTopologyService;
    }

    public void setLldpTopologyService(LldpTopologyService lldpTopologyService) {
        this.m_lldpTopologyService = lldpTopologyService;
    }

    public OspfTopologyService getOspfTopologyService() {
        return this.m_ospfTopologyService;
    }

    public void setOspfTopologyService(OspfTopologyService ospfTopologyService) {
        this.m_ospfTopologyService = ospfTopologyService;
    }

    public IpNetToMediaTopologyService getIpNetToMediaTopologyService() {
        return this.m_ipNetToMediaTopologyService;
    }

    public void setIpNetToMediaTopologyService(IpNetToMediaTopologyService ipNetToMediaTopologyService) {
        this.m_ipNetToMediaTopologyService = ipNetToMediaTopologyService;
    }

    public NodesOnmsTopologyUpdater getNodesTopologyUpdater() {
        return this.m_nodesTopologyUpdater;
    }

    public CdpOnmsTopologyUpdater getCdpTopologyUpdater() {
        return this.m_cdpTopologyUpdater;
    }

    public LldpOnmsTopologyUpdater getLldpTopologyUpdater() {
        return this.m_lldpTopologyUpdater;
    }

    public IsisOnmsTopologyUpdater getIsisTopologyUpdater() {
        return this.m_isisTopologyUpdater;
    }

    public BridgeOnmsTopologyUpdater getBridgeTopologyUpdater() {
        return this.m_bridgeTopologyUpdater;
    }

    public OspfOnmsTopologyUpdater getOspfTopologyUpdater() {
        return this.m_ospfTopologyUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        TopologyUpdater updater;
        LOG.info("reload: reload enlinkd daemon service");
        this.m_nodesTopologyUpdater.unschedule();
        this.m_nodesTopologyUpdater.unregister();
        NodesOnmsTopologyUpdater nodeupdater = NodesOnmsTopologyUpdater.clone(this.m_nodesTopologyUpdater);
        this.scheduleAndRegisterOnmsTopologyUpdater(nodeupdater);
        this.m_nodesTopologyUpdater = nodeupdater;
        if (this.m_linkdConfig.useOspfDiscovery()) {
            if (this.m_ospfTopologyUpdater.isRegistered()) {
                this.m_ospfTopologyUpdater.unschedule();
                this.m_ospfTopologyUpdater.unregister();
                updater = OspfOnmsTopologyUpdater.clone(this.m_ospfTopologyUpdater);
                this.scheduleAndRegisterOnmsTopologyUpdater(updater);
                this.m_ospfTopologyUpdater = updater;
            } else {
                this.scheduleAndRegisterOnmsTopologyUpdater(this.m_ospfTopologyUpdater);
            }
        } else {
            this.unscheduleAndUnregisterOnmsTopologyUpdater(this.m_ospfTopologyUpdater);
        }
        if (this.m_linkdConfig.useLldpDiscovery()) {
            if (this.m_lldpTopologyUpdater.isRegistered()) {
                this.m_lldpTopologyUpdater.unschedule();
                this.m_lldpTopologyUpdater.unregister();
                updater = LldpOnmsTopologyUpdater.clone(this.m_lldpTopologyUpdater);
                this.scheduleAndRegisterOnmsTopologyUpdater(updater);
                this.m_lldpTopologyUpdater = updater;
            } else {
                this.scheduleAndRegisterOnmsTopologyUpdater(this.m_lldpTopologyUpdater);
            }
        } else {
            this.unscheduleAndUnregisterOnmsTopologyUpdater(this.m_lldpTopologyUpdater);
        }
        if (this.m_linkdConfig.useIsisDiscovery()) {
            if (this.m_isisTopologyUpdater.isRegistered()) {
                this.m_isisTopologyUpdater.unschedule();
                this.m_isisTopologyUpdater.unregister();
                updater = IsisOnmsTopologyUpdater.clone(this.m_isisTopologyUpdater);
                this.scheduleAndRegisterOnmsTopologyUpdater(updater);
                this.m_isisTopologyUpdater = updater;
            } else {
                this.scheduleAndRegisterOnmsTopologyUpdater(this.m_isisTopologyUpdater);
            }
        } else {
            this.unscheduleAndUnregisterOnmsTopologyUpdater(this.m_isisTopologyUpdater);
        }
        if (this.m_linkdConfig.useCdpDiscovery()) {
            if (this.m_cdpTopologyUpdater.isRegistered()) {
                this.m_cdpTopologyUpdater.unschedule();
                this.m_cdpTopologyUpdater.unregister();
                updater = CdpOnmsTopologyUpdater.clone(this.m_cdpTopologyUpdater);
                this.scheduleAndRegisterOnmsTopologyUpdater(updater);
                this.m_cdpTopologyUpdater = updater;
            } else {
                this.scheduleAndRegisterOnmsTopologyUpdater(this.m_cdpTopologyUpdater);
            }
        } else {
            this.unscheduleAndUnregisterOnmsTopologyUpdater(this.m_cdpTopologyUpdater);
        }
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            if (this.m_bridgeTopologyUpdater.isRegistered()) {
                this.m_bridgeTopologyUpdater.unschedule();
                this.m_bridgeTopologyUpdater.unregister();
                updater = BridgeOnmsTopologyUpdater.clone(this.m_bridgeTopologyUpdater);
                this.scheduleAndRegisterOnmsTopologyUpdater(updater);
                this.m_bridgeTopologyUpdater = updater;
            } else {
                this.scheduleAndRegisterOnmsTopologyUpdater(this.m_bridgeTopologyUpdater);
            }
        } else {
            this.unscheduleAndUnregisterOnmsTopologyUpdater(this.m_bridgeTopologyUpdater);
        }
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            this.m_discoveryBridgeDomains.unschedule();
            this.m_discoveryBridgeDomains = DiscoveryBridgeDomains.clone(this.m_discoveryBridgeDomains);
            this.scheduleDiscoveryBridgeDomain();
        } else {
            this.unscheduleDiscoveryBridgeDomain();
        }
        Map<Integer, List<NodeCollector>> map = this.m_nodes;
        synchronized (map) {
            HashSet nodes = new HashSet();
            for (List<NodeCollector> list : this.m_nodes.values()) {
                list.stream().forEach(coll -> {
                    coll.unschedule();
                    nodes.add(coll.getNode());
                });
            }
            this.m_nodes.clear();
            nodes.stream().forEach(node -> this.m_nodes.put(node.getNodeId(), this.scheduleCollectionForNode((Node)node)));
        }
    }

    public void reloadConfig() {
        LOG.info("reloadConfig: reload enlinkd configuration file");
        try {
            this.m_linkdConfig.reload();
        }
        catch (IOException e) {
            LOG.error("reloadConfig: cannot reload config: {}", (Object)e.getMessage());
            return;
        }
        this.reload();
    }

    public void reloadTopology() {
        LOG.info("reloadTopology: reload enlinkd topology updaters");
        for (ProtocolSupported protocol : ProtocolSupported.values()) {
            this.forceTopologyUpdaterRun(protocol);
            this.runTopologyUpdater(protocol);
        }
    }
}

