/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.Map;
import org.opennms.netmgt.enlinkd.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyException;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;

public class NodesOnmsTopologyUpdater
extends TopologyUpdater {
    public static NodesOnmsTopologyUpdater clone(NodesOnmsTopologyUpdater bpu) {
        NodesOnmsTopologyUpdater update = new NodesOnmsTopologyUpdater(bpu.getTopologyDao(), bpu.getNodeTopologyService());
        update.setRunned(bpu.isRunned());
        update.setTopology(bpu.getTopology());
        return update;
    }

    public NodesOnmsTopologyUpdater(OnmsTopologyDao topologyDao, NodeTopologyService nodeTopologyService) {
        super((TopologyService)nodeTopologyService, topologyDao, nodeTopologyService);
    }

    @Override
    public String getName() {
        return "NodesTopologyUpdater";
    }

    @Override
    public OnmsTopology buildTopology() throws OnmsTopologyException {
        Map<Integer, IpInterfaceTopologyEntity> ipMap = this.getIpPrimaryMap();
        OnmsTopology topology = new OnmsTopology();
        for (NodeTopologyEntity element : this.getNodeMap().values()) {
            topology.getVertices().add(NodesOnmsTopologyUpdater.create(element, ipMap.get(element.getId())));
        }
        NodeTopologyEntity defaultFocusPoint = this.getDefaultFocusPoint();
        if (defaultFocusPoint != null) {
            topology.setDefaultVertex(NodesOnmsTopologyUpdater.create(defaultFocusPoint, ipMap.get(defaultFocusPoint.getId())));
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() throws OnmsTopologyException {
        return NodesOnmsTopologyUpdater.create(ProtocolSupported.NODES);
    }
}

