/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.service.api.IpNetToMediaTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.snmp.IpNetToMediaTableTracker;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryIpNetToMedia
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryIpNetToMedia.class);
    private final IpNetToMediaTopologyService m_ipNetToMediaTopologyService;

    public NodeDiscoveryIpNetToMedia(EventForwarder eventForwarder, IpNetToMediaTopologyService ipNetToMediaTopologyService, LocationAwareSnmpClient locationAwareSnmpClient, long interval, long initial, Node node) {
        super(eventForwarder, locationAwareSnmpClient, interval, initial, node);
        this.m_ipNetToMediaTopologyService = ipNetToMediaTopologyService;
    }

    @Override
    protected void runNodeDiscovery() {
        Date now = new Date();
        IpNetToMediaTableTracker ipNetToMediaTableTracker = new IpNetToMediaTableTracker(){

            public void processIpNetToMediaRow(IpNetToMediaTableTracker.IpNetToMediaRow row) {
                IpNetToMedia macep = row.getIpNetToMedia();
                if (macep.getPhysAddress() != null && macep.getNetAddress() != null && macep.getSourceIfIndex() != null && (macep.getIpNetToMediaType() == IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC || macep.getIpNetToMediaType() == IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_STATIC)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("processIpNetToMediaRow: node [{}], mac address {} and ip {} mediatype {}. saving", new Object[]{NodeDiscoveryIpNetToMedia.this.getNodeId(), macep.getPhysAddress(), InetAddressUtils.str((InetAddress)macep.getNetAddress()), macep.getIpNetToMediaType()});
                    }
                    NodeDiscoveryIpNetToMedia.this.m_ipNetToMediaTopologyService.store(NodeDiscoveryIpNetToMedia.this.getNodeId(), macep);
                    return;
                }
                if (macep.getPhysAddress() == null && macep.getNetAddress() == null) {
                    LOG.debug("processIpNetToMediaRow: node [{}], null:null:{}. ip and mac addresses null. skipping", (Object)NodeDiscoveryIpNetToMedia.this.getNodeId(), (Object)macep.getIpNetToMediaType());
                    return;
                }
                if (macep.getPhysAddress() == null) {
                    LOG.debug("processIpNetToMediaRow: node [{}], null:{}:{}. mac address null. skipping", new Object[]{NodeDiscoveryIpNetToMedia.this.getNodeId(), InetAddressUtils.str((InetAddress)macep.getNetAddress()), macep.getIpNetToMediaType()});
                    return;
                }
                if (macep.getNetAddress() == null) {
                    LOG.debug("processIpNetToMediaRow: node [{}], {}:null:{}. ip address null. skipping", new Object[]{NodeDiscoveryIpNetToMedia.this.getNodeId(), macep.getPhysAddress(), macep.getIpNetToMediaType()});
                    return;
                }
                LOG.debug("processIpNetToMediaRow: node [{}],  {}:{}:{}:{}. not valid. skipping", new Object[]{NodeDiscoveryIpNetToMedia.this.getNodeId(), macep.getPhysAddress(), InetAddressUtils.str((InetAddress)macep.getNetAddress()), macep.getIpNetToMediaType(), macep.getSourceIfIndex()});
            }
        };
        SnmpAgentConfig peer = this.getSnmpAgentConfig();
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ipNetToMediaTableTracker).withDescription("ipNetToMedia").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        this.m_ipNetToMediaTopologyService.reconcile(this.getNodeId(), now);
    }

    @Override
    public String getName() {
        return "NodeDiscoveryIpNetToMedia";
    }
}

