/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.enlinkd.DiscoveryBridgeDomains;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.NodeDiscoveryBridge;
import org.opennms.netmgt.enlinkd.NodeDiscoveryCdp;
import org.opennms.netmgt.enlinkd.NodeDiscoveryIpNetToMedia;
import org.opennms.netmgt.enlinkd.NodeDiscoveryIsis;
import org.opennms.netmgt.enlinkd.NodeDiscoveryLldp;
import org.opennms.netmgt.enlinkd.NodeDiscoveryOspf;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.CdpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.IpNetToMediaTopologyService;
import org.opennms.netmgt.enlinkd.service.api.IsisTopologyService;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class EnhancedLinkd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedLinkd.class);
    private static final String LOG_PREFIX = "enlinkd";
    private LegacyScheduler m_scheduler;
    private NodeTopologyService m_queryMgr;
    private BridgeTopologyService m_bridgeTopologyService;
    private CdpTopologyService m_cdpTopologyService;
    private IsisTopologyService m_isisTopologyService;
    private IpNetToMediaTopologyService m_ipNetToMediaTopologyService;
    private LldpTopologyService m_lldpTopologyService;
    private OspfTopologyService m_ospfTopologyService;
    private EnhancedLinkdConfig m_linkdConfig;
    private Map<Integer, List<NodeDiscovery>> m_nodes = new HashMap<Integer, List<NodeDiscovery>>();
    private volatile EventForwarder m_eventForwarder;
    @Autowired
    private LocationAwareSnmpClient m_locationAwareSnmpClient;
    private DiscoveryBridgeDomains m_discoveryBridgeDomains;

    public EnhancedLinkd() {
        super(LOG_PREFIX);
    }

    protected void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"must set the eventForwarder property");
        this.createScheduler();
        LOG.debug("init: Loading nodes.....");
        List nodes = this.m_queryMgr.findAllSnmpNode();
        Assert.notNull(this.m_nodes);
        LOG.debug("init: Nodes loaded.");
        LOG.debug("init: Loading Bridge Topology.....");
        this.m_bridgeTopologyService.load();
        LOG.debug("init: Bridge Topology loaded.");
        this.scheduleCollection(nodes);
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            this.scheduleDiscoveryBridgeDomain();
        }
    }

    private void createScheduler() {
        try {
            LOG.debug("init: Creating EnhancedLinkd scheduler");
            this.setScheduler(new LegacyScheduler("EnhancedLinkd", this.getLinkdConfig().getThreads()));
        }
        catch (RuntimeException e) {
            LOG.error("init: Failed to create EnhancedLinkd scheduler", (Throwable)e);
            throw e;
        }
    }

    public void scheduleDiscoveryBridgeDomain() {
        this.m_discoveryBridgeDomains = new DiscoveryBridgeDomains(this.getEventForwarder(), this.getBridgeTopologyService(), this.getBridgeTopologyInterval(), this.getBridgeTopologyInterval() + this.getInitialSleepTime(), this.getDiscoveryBridgeThreads());
        LOG.debug("scheduleDiscoveryBridgeDomain: Scheduling {}", (Object)this.m_discoveryBridgeDomains.getInfo());
        this.m_discoveryBridgeDomains.setScheduler(this.m_scheduler);
        this.m_discoveryBridgeDomains.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCollection(List<Node> nodes) {
        List<Node> list = nodes;
        synchronized (list) {
            for (Node node : nodes) {
                this.scheduleCollectionForNode(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCollectionForNode(Node node) {
        ArrayList<NodeDiscovery> colls = new ArrayList<NodeDiscovery>();
        if (this.m_linkdConfig.useLldpDiscovery()) {
            LOG.debug("getSnmpCollections: adding Lldp Discovery: {}", (Object)node);
            colls.add(new NodeDiscoveryLldp(this.getEventForwarder(), this.getLldpTopologyService(), this.getLocationAwareSnmpClient(), this.getRescanInterval(), this.getInitialSleepTime(), node));
        }
        if (this.m_linkdConfig.useCdpDiscovery()) {
            LOG.debug("getSnmpCollections: adding Cdp Discovery: {}", (Object)node);
            colls.add(new NodeDiscoveryCdp(this.getEventForwarder(), this.getCdpTopologyService(), this.getLocationAwareSnmpClient(), this.getRescanInterval(), this.getInitialSleepTime(), node));
        }
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            LOG.debug("getSnmpCollections: adding IpNetToMedia Discovery: {}", (Object)node);
            colls.add(new NodeDiscoveryIpNetToMedia(this.getEventForwarder(), this.getIpNetToMediaTopologyService(), this.getLocationAwareSnmpClient(), this.getRescanInterval(), this.getInitialSleepTime(), node));
            LOG.debug("getSnmpCollections: adding Bridge Discovery: {}", (Object)node);
            colls.add(new NodeDiscoveryBridge(this.getEventForwarder(), this.getBridgeTopologyService(), this.getMaxbft(), this.getLocationAwareSnmpClient(), this.getRescanInterval(), this.getInitialSleepTime(), node));
        }
        if (this.m_linkdConfig.useOspfDiscovery()) {
            LOG.debug("getSnmpCollections: adding Ospf Discovery: {}", (Object)node);
            colls.add(new NodeDiscoveryOspf(this.getEventForwarder(), this.getOspfTopologyService(), this.getLocationAwareSnmpClient(), this.getRescanInterval(), this.getInitialSleepTime(), node));
        }
        if (this.m_linkdConfig.useIsisDiscovery()) {
            LOG.debug("getSnmpCollections: adding Is-Is Discovery: {}", (Object)node);
            colls.add(new NodeDiscoveryIsis(this.getEventForwarder(), this.getIsisTopologyService(), this.getLocationAwareSnmpClient(), this.getRescanInterval(), this.getInitialSleepTime(), node));
        }
        for (NodeDiscovery coll : colls) {
            LOG.debug("ScheduleCollectionForNode: Scheduling {}", (Object)coll.getInfo());
            coll.setScheduler(this.m_scheduler);
            coll.schedule();
        }
        Map<Integer, List<NodeDiscovery>> map = this.m_nodes;
        synchronized (map) {
            LOG.debug("scheduleNodeCollection: adding node {} to the collection", (Object)node);
            this.m_nodes.put(node.getNodeId(), colls);
        }
    }

    protected synchronized void onStart() {
        this.m_scheduler.start();
    }

    protected synchronized void onStop() {
        this.m_scheduler.stop();
        this.m_scheduler = null;
    }

    protected synchronized void onPause() {
        this.m_scheduler.pause();
    }

    protected synchronized void onResume() {
        this.m_scheduler.resume();
    }

    public boolean scheduleNodeCollection(int nodeid) {
        if (this.m_nodes.containsKey(nodeid)) {
            LOG.debug("scheduleNodeCollection: node:[{}], node Collection already Scheduled ", (Object)nodeid);
            return false;
        }
        LOG.debug("scheduleNodeCollection: Loading node {} from database", (Object)nodeid);
        Node node = this.m_queryMgr.getSnmpNode(nodeid);
        if (node == null) {
            LOG.warn("scheduleNodeCollection: Failed to get linkable node from database with ID {}. Exiting", (Object)nodeid);
            return false;
        }
        this.scheduleCollectionForNode(node);
        return true;
    }

    public boolean runSingleSnmpCollection(int nodeId) {
        boolean allready = true;
        if (!this.m_nodes.containsKey(nodeId)) {
            return false;
        }
        for (NodeDiscovery snmpColl : this.m_nodes.get(nodeId)) {
            if (!snmpColl.isReady()) {
                allready = false;
                continue;
            }
            snmpColl.runDiscovery();
        }
        return allready;
    }

    public void runDiscoveryBridgeDomains() {
        if (this.m_discoveryBridgeDomains != null) {
            this.m_discoveryBridgeDomains.runDiscovery();
        }
    }

    public DiscoveryBridgeDomains getDiscoveryBridgeDomains() {
        return this.m_discoveryBridgeDomains;
    }

    void wakeUpNodeCollection(int nodeid) {
        if (!this.m_nodes.containsKey(nodeid)) {
            LOG.warn("wakeUpNodeCollection: node not found during scheduling with ID {}", (Object)nodeid);
            this.scheduleNodeCollection(nodeid);
            return;
        }
        this.m_nodes.get(nodeid).stream().forEach(collection -> collection.wakeUp());
    }

    void deleteNode(int nodeid) {
        LOG.info("deleteNode: deleting LinkableNode for node {}", (Object)nodeid);
        if (this.m_nodes.containsKey(nodeid)) {
            this.m_nodes.remove(nodeid).stream().forEach(coll -> coll.suspend());
        }
        try {
            this.m_bridgeTopologyService.delete(nodeid);
        }
        catch (BridgeTopologyException e) {
            LOG.error("deleteNode: {}", (Object)e.getMessage());
        }
        this.m_cdpTopologyService.delete(nodeid);
        this.m_isisTopologyService.delete(nodeid);
        this.m_lldpTopologyService.delete(nodeid);
        this.m_ospfTopologyService.delete(nodeid);
        this.m_ipNetToMediaTopologyService.delete(nodeid);
    }

    void rescheduleNodeCollection(int nodeid) {
        LOG.info("rescheduleNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        if (this.m_nodes.containsKey(nodeid)) {
            this.m_nodes.remove(nodeid).stream().forEach(coll -> coll.suspend());
        }
        this.scheduleNodeCollection(nodeid);
    }

    void suspendNodeCollection(int nodeid) {
        LOG.info("suspendNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        if (this.m_nodes.containsKey(nodeid)) {
            this.m_nodes.get(nodeid).stream().forEach(coll -> coll.suspend());
        }
    }

    public NodeTopologyService getQueryManager() {
        return this.m_queryMgr;
    }

    public void setQueryManager(NodeTopologyService queryMgr) {
        this.m_queryMgr = queryMgr;
    }

    public LegacyScheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public EnhancedLinkdConfig getLinkdConfig() {
        return this.m_linkdConfig;
    }

    public void setLinkdConfig(EnhancedLinkdConfig config) {
        this.m_linkdConfig = config;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public String getSource() {
        return LOG_PREFIX;
    }

    public long getInitialSleepTime() {
        return this.m_linkdConfig.getInitialSleepTime();
    }

    public long getRescanInterval() {
        return this.m_linkdConfig.getRescanInterval();
    }

    public long getBridgeTopologyInterval() {
        return this.m_linkdConfig.getBridgeTopologyInterval();
    }

    public int getDiscoveryBridgeThreads() {
        return this.m_linkdConfig.getDiscoveryBridgeThreads();
    }

    public LocationAwareSnmpClient getLocationAwareSnmpClient() {
        return this.m_locationAwareSnmpClient;
    }

    public int getMaxbft() {
        return this.m_linkdConfig.getMaxBft();
    }

    public BridgeTopologyService getBridgeTopologyService() {
        return this.m_bridgeTopologyService;
    }

    public void setBridgeTopologyService(BridgeTopologyService bridgeTopologyService) {
        this.m_bridgeTopologyService = bridgeTopologyService;
    }

    public CdpTopologyService getCdpTopologyService() {
        return this.m_cdpTopologyService;
    }

    public void setCdpTopologyService(CdpTopologyService cdpTopologyService) {
        this.m_cdpTopologyService = cdpTopologyService;
    }

    public IsisTopologyService getIsisTopologyService() {
        return this.m_isisTopologyService;
    }

    public void setIsisTopologyService(IsisTopologyService isisTopologyService) {
        this.m_isisTopologyService = isisTopologyService;
    }

    public LldpTopologyService getLldpTopologyService() {
        return this.m_lldpTopologyService;
    }

    public void setLldpTopologyService(LldpTopologyService lldpTopologyService) {
        this.m_lldpTopologyService = lldpTopologyService;
    }

    public OspfTopologyService getOspfTopologyService() {
        return this.m_ospfTopologyService;
    }

    public void setOspfTopologyService(OspfTopologyService ospfTopologyService) {
        this.m_ospfTopologyService = ospfTopologyService;
    }

    public IpNetToMediaTopologyService getIpNetToMediaTopologyService() {
        return this.m_ipNetToMediaTopologyService;
    }

    public void setIpNetToMediaTopologyService(IpNetToMediaTopologyService ipNetToMediaTopologyService) {
        this.m_ipNetToMediaTopologyService = ipNetToMediaTopologyService;
    }
}

