/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.enlinkd;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="enlinkd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="enlinkd-configuration.xsd")
public class EnlinkdConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="threads", required=true)
    private Integer m_threads;
    @XmlAttribute(name="initial_sleep_time")
    private Long m_initialSleepTime;
    @XmlAttribute(name="rescan_interval")
    private Long m_rescanInterval;
    @XmlAttribute(name="bridge_topology_interval")
    private Long m_bridgeTopologyInterval;
    @XmlAttribute(name="max_bft")
    private Integer m_maxBft;
    @XmlAttribute(name="discovery-bridge-threads")
    private Integer m_discoveryBridgeThreads;
    @XmlAttribute(name="use-cdp-discovery")
    private Boolean m_useCdpDiscovery;
    @XmlAttribute(name="use-bridge-discovery")
    private Boolean m_useBridgeDiscovery;
    @XmlAttribute(name="use-lldp-discovery")
    private Boolean m_useLldpDiscovery;
    @XmlAttribute(name="use-ospf-discovery")
    private Boolean m_useOspfDiscovery;
    @XmlAttribute(name="use-isis-discovery")
    private Boolean m_useIsisDiscovery;

    public Integer getThreads() {
        return this.m_threads;
    }

    public void setThreads(Integer threads) {
        this.m_threads = (Integer)ConfigUtils.assertNotNull((Object)threads, (String)"threads");
    }

    public Long getInitialSleepTime() {
        return this.m_initialSleepTime == null ? 60000L : this.m_initialSleepTime;
    }

    public void setInitialSleepTime(Long initialSleepTime) {
        this.m_initialSleepTime = initialSleepTime;
    }

    public Long getRescanInterval() {
        return this.m_rescanInterval == null ? 86400000L : this.m_rescanInterval;
    }

    public void setRescanInterval(Long rescanInterval) {
        this.m_rescanInterval = rescanInterval;
    }

    public Long getBridgeTopologyInterval() {
        return this.m_bridgeTopologyInterval == null ? 300000L : this.m_bridgeTopologyInterval;
    }

    public void setBridgeTopologyInterval(Long bridgeTopologyInterval) {
        this.m_bridgeTopologyInterval = bridgeTopologyInterval;
    }

    public Integer getMaxBft() {
        return this.m_maxBft != null ? this.m_maxBft : 100;
    }

    public void setMaxBft(Integer maxBft) {
        this.m_maxBft = maxBft;
    }

    public Integer getDiscoveryBridgeThreads() {
        return this.m_discoveryBridgeThreads != null ? this.m_discoveryBridgeThreads : 1;
    }

    public void setDiscoveryBridgeThreads(Integer discoveryBridgeThreads) {
        this.m_discoveryBridgeThreads = discoveryBridgeThreads;
    }

    public Boolean getUseCdpDiscovery() {
        return this.m_useCdpDiscovery != null ? this.m_useCdpDiscovery : true;
    }

    public void setUseCdpDiscovery(Boolean useCdpDiscovery) {
        this.m_useCdpDiscovery = useCdpDiscovery;
    }

    public Boolean getUseBridgeDiscovery() {
        return this.m_useBridgeDiscovery != null ? this.m_useBridgeDiscovery : true;
    }

    public void setUseBridgeDiscovery(Boolean useBridgeDiscovery) {
        this.m_useBridgeDiscovery = useBridgeDiscovery;
    }

    public Boolean getUseLldpDiscovery() {
        return this.m_useLldpDiscovery != null ? this.m_useLldpDiscovery : true;
    }

    public void setUseLldpDiscovery(Boolean useLldpDiscovery) {
        this.m_useLldpDiscovery = useLldpDiscovery;
    }

    public Boolean getUseOspfDiscovery() {
        return this.m_useOspfDiscovery != null ? this.m_useOspfDiscovery : true;
    }

    public void setUseOspfDiscovery(Boolean useOspfDiscovery) {
        this.m_useOspfDiscovery = useOspfDiscovery;
    }

    public Boolean getUseIsisDiscovery() {
        return this.m_useIsisDiscovery != null ? this.m_useIsisDiscovery : true;
    }

    public void setUseIsisDiscovery(Boolean useIsisDiscovery) {
        this.m_useIsisDiscovery = useIsisDiscovery;
    }

    public int hashCode() {
        int hash = Objects.hash(this.m_threads, this.m_initialSleepTime, this.m_rescanInterval, this.m_bridgeTopologyInterval, this.m_maxBft, this.m_discoveryBridgeThreads, this.m_useCdpDiscovery, this.m_useBridgeDiscovery, this.m_useLldpDiscovery, this.m_useOspfDiscovery, this.m_useIsisDiscovery);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EnlinkdConfiguration) {
            EnlinkdConfiguration that = (EnlinkdConfiguration)obj;
            return Objects.equals(this.m_threads, that.m_threads) && Objects.equals(this.m_initialSleepTime, that.m_initialSleepTime) && Objects.equals(this.m_rescanInterval, that.m_rescanInterval) && Objects.equals(this.m_bridgeTopologyInterval, that.m_bridgeTopologyInterval) && Objects.equals(this.m_maxBft, that.m_maxBft) && Objects.equals(this.m_discoveryBridgeThreads, that.m_discoveryBridgeThreads) && Objects.equals(this.m_useCdpDiscovery, that.m_useCdpDiscovery) && Objects.equals(this.m_useBridgeDiscovery, that.m_useBridgeDiscovery) && Objects.equals(this.m_useLldpDiscovery, that.m_useLldpDiscovery) && Objects.equals(this.m_useOspfDiscovery, that.m_useOspfDiscovery) && Objects.equals(this.m_useIsisDiscovery, that.m_useIsisDiscovery);
        }
        return false;
    }
}

