/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.collect.Table;
import java.util.Map;
import org.opennms.netmgt.enlinkd.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.model.OspfLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyException;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class OspfOnmsTopologyUpdater
extends TopologyUpdater {
    private final OspfTopologyService m_ospfTopologyService;

    public static OspfOnmsTopologyUpdater clone(OspfOnmsTopologyUpdater bpu) {
        OspfOnmsTopologyUpdater update = new OspfOnmsTopologyUpdater(bpu.getTopologyDao(), bpu.getOspfTopologyService(), bpu.getNodeTopologyService());
        update.setRunned(bpu.isRunned());
        update.setTopology(bpu.getTopology());
        return update;
    }

    public static OnmsTopologyPort create(OnmsTopologyVertex source, OspfLinkTopologyEntity sourcelink, OspfLinkTopologyEntity targetlink, SnmpInterfaceTopologyEntity snmpiface) throws OnmsTopologyException {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)sourcelink.getId().toString(), (OnmsTopologyVertex)source, (Integer)sourcelink.getOspfIfIndex());
        port.setIfindex(sourcelink.getOspfIfIndex());
        if (snmpiface != null) {
            port.setIfname(snmpiface.getIfName());
        }
        port.setAddr(Topology.getRemoteAddress((OspfLinkTopologyEntity)targetlink));
        port.setToolTipText(Topology.getPortTextString((String)source.getLabel(), (Integer)port.getIndex(), (String)port.getAddr(), (SnmpInterfaceTopologyEntity)snmpiface));
        return port;
    }

    public OspfOnmsTopologyUpdater(OnmsTopologyDao topologyDao, OspfTopologyService ospfTopologyService, NodeTopologyService nodeTopologyService) {
        super((TopologyService)ospfTopologyService, topologyDao, nodeTopologyService);
        this.m_ospfTopologyService = ospfTopologyService;
    }

    @Override
    public String getName() {
        return "OspfTopologyUpdater";
    }

    @Override
    public OnmsTopology buildTopology() throws OnmsTopologyException {
        Map<Integer, NodeTopologyEntity> nodeMap = this.getNodeMap();
        Map<Integer, IpInterfaceTopologyEntity> ipMap = this.getIpPrimaryMap();
        Table<Integer, Integer, SnmpInterfaceTopologyEntity> nodeToOnmsSnmpTable = this.getSnmpInterfaceTable();
        OnmsTopology topology = new OnmsTopology();
        for (OspfElement element : this.m_ospfTopologyService.findAllOspfElements()) {
            topology.getVertices().add(OspfOnmsTopologyUpdater.create(nodeMap.get(element.getNode().getId()), ipMap.get(element.getNode().getId())));
        }
        for (TopologyConnection pair : this.m_ospfTopologyService.match()) {
            OspfLinkTopologyEntity right;
            OspfLinkTopologyEntity left = (OspfLinkTopologyEntity)pair.getLeft();
            if (topology.getVertex(left.getNodeIdAsString()) == null) {
                topology.getVertices().add(OspfOnmsTopologyUpdater.create(nodeMap.get(left.getNodeId()), ipMap.get(left.getNodeId())));
            }
            if (topology.getVertex((right = (OspfLinkTopologyEntity)pair.getRight()).getNodeIdAsString()) == null) {
                topology.getVertices().add(OspfOnmsTopologyUpdater.create(nodeMap.get(right.getNodeId()), ipMap.get(right.getNodeId())));
            }
            topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getDefaultEdgeId((int)left.getId(), (int)right.getId()), (OnmsTopologyPort)OspfOnmsTopologyUpdater.create(topology.getVertex(left.getNodeIdAsString()), left, right, (SnmpInterfaceTopologyEntity)nodeToOnmsSnmpTable.get((Object)left.getNodeId(), (Object)left.getOspfIfIndex())), (OnmsTopologyPort)OspfOnmsTopologyUpdater.create(topology.getVertex(right.getNodeIdAsString()), right, left, (SnmpInterfaceTopologyEntity)nodeToOnmsSnmpTable.get((Object)right.getNodeId(), (Object)right.getOspfIfIndex()))));
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() throws OnmsTopologyException {
        return OspfOnmsTopologyUpdater.create(ProtocolSupported.OSPF);
    }

    public OspfTopologyService getOspfTopologyService() {
        return this.m_ospfTopologyService;
    }
}

