/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Discovery
implements ReadyRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(Discovery.class);
    private LegacyScheduler m_scheduler;
    private long m_poll_interval = 1800000L;
    private long m_initial_sleep_time = 600000L;
    private boolean m_suspendCollection = false;
    private boolean m_unschedule = false;

    public Discovery(long interval, long initial) {
        this.m_poll_interval = interval;
        this.m_initial_sleep_time = initial;
    }

    public Discovery() {
    }

    public abstract String getName();

    public abstract void runDiscovery();

    public void run() {
        if (this.m_unschedule) {
            LOG.info("run: unscheduled {}", (Object)this.getInfo());
            return;
        }
        if (this.m_suspendCollection) {
            LOG.info("run: suspended {}", (Object)this.getInfo());
            this.schedule();
            return;
        }
        LOG.info("run: running {}", (Object)this.getInfo());
        this.runDiscovery();
        this.reschedule();
    }

    public LegacyScheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.m_initial_sleep_time, (ReadyRunnable)this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.m_poll_interval, (ReadyRunnable)this);
    }

    public boolean isReady() {
        return true;
    }

    public void unschedule() {
        this.m_unschedule = true;
    }

    public void suspend() {
        this.m_suspendCollection = true;
    }

    public void wakeUp() {
        this.m_suspendCollection = false;
    }

    public String getInfo() {
        return this.getName() + " initial:" + this.m_initial_sleep_time + " interval:" + this.m_poll_interval;
    }

    public long getPollInterval() {
        return this.m_poll_interval;
    }

    public void setPollInterval(long interval) {
        this.m_poll_interval = interval;
    }

    public long getInitialSleepTime() {
        return this.m_initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.m_initial_sleep_time = initial_sleep_time;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.m_initial_sleep_time ^ this.m_initial_sleep_time >>> 32);
        result = 31 * result + (int)(this.m_poll_interval ^ this.m_poll_interval >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Discovery other = (Discovery)obj;
        if (this.m_initial_sleep_time != other.m_initial_sleep_time) {
            return false;
        }
        return this.m_poll_interval == other.m_poll_interval;
    }
}

