/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.enlinkd.Discovery;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeDiscovery
extends Discovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscovery.class);
    protected final Node m_node;
    private final LocationAwareSnmpClient m_locationAwareSnmpClient;

    public NodeDiscovery(EventForwarder eventForwarder, LocationAwareSnmpClient locationAwareSnmpClient, long interval, long initial, Node node) {
        super(eventForwarder, interval, initial);
        this.m_node = node;
        this.m_locationAwareSnmpClient = locationAwareSnmpClient;
    }

    protected abstract void runNodeDiscovery();

    @Override
    public void runDiscovery() {
        if (this.m_suspendCollection) {
            this.sendSuspendedEvent(this.getNodeId());
        } else {
            this.sendStartEvent(this.getNodeId());
            LOG.info("run: node [{}], start {} collection.", (Object)this.getNodeId(), (Object)this.getName());
            this.runNodeDiscovery();
            LOG.info("run: node [{}], end {} collection.", (Object)this.getNodeId(), (Object)this.getName());
            this.sendCompletedEvent(this.getNodeId());
        }
    }

    public InetAddress getPrimaryIpAddress() {
        return this.m_node.getSnmpPrimaryIpAddr();
    }

    public String getPrimaryIpAddressString() {
        return InetAddressUtils.str((InetAddress)this.m_node.getSnmpPrimaryIpAddr());
    }

    @Override
    public String getInfo() {
        return this.getName() + " node=" + this.getNodeId() + " ip=" + InetAddressUtils.str((InetAddress)this.getPrimaryIpAddress());
    }

    public int getNodeId() {
        return this.m_node.getNodeId();
    }

    public String getSysoid() {
        return this.m_node.getSysoid();
    }

    public String getSysname() {
        return this.m_node.getSysname();
    }

    public String getLocation() {
        return this.m_node.getLocation();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_node == null ? 0 : this.m_node.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeDiscovery other = (NodeDiscovery)obj;
        return !(this.m_node == null ? other.m_node != null : !this.m_node.equals((Object)other.m_node));
    }

    public SnmpAgentConfig getSnmpAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.m_node.getSnmpPrimaryIpAddr(), this.m_node.getLocation());
    }

    public LocationAwareSnmpClient getLocationAwareSnmpClient() {
        return this.m_locationAwareSnmpClient;
    }
}

