/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.common.NodeCollector;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.enlinkd.snmp.OspfGeneralGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIfTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIpAddrTableGetter;
import org.opennms.netmgt.enlinkd.snmp.OspfNbrTableTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryOspf
extends NodeCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryOspf.class);
    private final OspfTopologyService m_ospfTopologyService;

    public NodeDiscoveryOspf(OspfTopologyService ospfTopologyService, LocationAwareSnmpClient locationAwareSnmpClient, long interval, long initial, Node node) {
        super(locationAwareSnmpClient, interval, initial, node);
        this.m_ospfTopologyService = ospfTopologyService;
    }

    public void collect() {
        Date now = new Date();
        SnmpAgentConfig peer = this.getSnmpAgentConfig();
        OspfIpAddrTableGetter ipAddrTableGetter = new OspfIpAddrTableGetter(peer, this.getLocationAwareSnmpClient(), this.getLocation(), this.getNodeId());
        OspfGeneralGroupTracker ospfGeneralGroup = new OspfGeneralGroupTracker();
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ospfGeneralGroup).withDescription("ospfGeneralGroup").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: ospf mib not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: ospf mib not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        if (ospfGeneralGroup.getOspfRouterId() == null) {
            LOG.info("run: node[{}]: ospf mib not supported", (Object)this.getNodeId());
            return;
        }
        if (ospfGeneralGroup.getOspfRouterId().equals(InetAddressUtils.addr((String)"0.0.0.0"))) {
            LOG.info("run: node[{}]: ospf mib not supported not valid ospf identifier 0.0.0.0", (Object)this.getNodeId());
            return;
        }
        if (OspfElement.Status.get((Integer)ospfGeneralGroup.getOspfAdminStat()) == OspfElement.Status.disabled) {
            LOG.info("run: node[{}]: ospf mib not supported ospf status: disabled", (Object)this.getNodeId());
            return;
        }
        this.m_ospfTopologyService.store(this.getNodeId(), ipAddrTableGetter.get(ospfGeneralGroup.getOspfElement()));
        final ArrayList links = new ArrayList();
        OspfNbrTableTracker ospfNbrTableTracker = new OspfNbrTableTracker(){

            @Override
            public void processOspfNbrRow(OspfNbrTableTracker.OspfNbrRow row) {
                links.add(row.getOspfLink());
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ospfNbrTableTracker).withDescription("ospfNbrTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        final ArrayList localOspfPorts = new ArrayList();
        OspfIfTableTracker ospfIfTableTracker = new OspfIfTableTracker(){

            @Override
            public void processOspfIfRow(OspfIfTableTracker.OspfIfRow row) {
                localOspfPorts.add(row.getOspfLink());
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ospfIfTableTracker).withDescription("ospfIfTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        for (OspfLink link : links) {
            for (OspfLink localospfport : localOspfPorts) {
                if (localospfport.getOspfAddressLessIndex() != 0 && link.getOspfRemAddressLessIndex() != 0) {
                    link.setOspfIpAddr(localospfport.getOspfIpAddr());
                    link.setOspfAddressLessIndex(localospfport.getOspfAddressLessIndex());
                    link.setOspfIfIndex(localospfport.getOspfAddressLessIndex());
                    break;
                }
                if (localospfport.getOspfAddressLessIndex() == 0 && link.getOspfRemAddressLessIndex() != 0 || localospfport.getOspfAddressLessIndex() != 0 && link.getOspfRemAddressLessIndex() == 0 || !InetAddressUtils.inSameNetwork((InetAddress)(localospfport = ipAddrTableGetter.get(localospfport)).getOspfIpAddr(), (InetAddress)link.getOspfRemIpAddr(), (InetAddress)localospfport.getOspfIpMask())) continue;
                link.setOspfIpAddr(localospfport.getOspfIpAddr());
                link.setOspfAddressLessIndex(localospfport.getOspfAddressLessIndex());
                link.setOspfIpMask(localospfport.getOspfIpMask());
                link.setOspfIfIndex(localospfport.getOspfIfIndex());
                break;
            }
            this.m_ospfTopologyService.store(this.getNodeId(), link);
        }
        this.m_ospfTopologyService.reconcile(this.getNodeId(), now);
    }

    public String getName() {
        return "NodeDiscoveryOspf";
    }
}

