/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.enlinkd.snmp.SnmpGetter;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpLocPortGetter
extends SnmpGetter {
    private static final Logger LOG = LoggerFactory.getLogger(LldpLocPortGetter.class);
    public static final SnmpObjId LLDP_LOC_PORTID_SUBTYPE = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.2");
    public static final SnmpObjId LLDP_LOC_PORTID = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.3");
    public static final SnmpObjId LLDP_LOC_DESCR = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.4");

    public LldpLocPortGetter(SnmpAgentConfig peer, LocationAwareSnmpClient client, String location, Integer nodeid) {
        super(peer, client, location, nodeid);
    }

    public List<SnmpValue> get(Integer lldpRemLocalPortNum) {
        ArrayList<SnmpObjId> oids = new ArrayList<SnmpObjId>(3);
        oids.add(SnmpObjId.get((SnmpObjId)LLDP_LOC_PORTID_SUBTYPE));
        oids.add(SnmpObjId.get((SnmpObjId)LLDP_LOC_PORTID));
        oids.add(SnmpObjId.get((SnmpObjId)LLDP_LOC_DESCR));
        return this.get(oids, lldpRemLocalPortNum);
    }

    public LldpLink getLldpLink(LldpLink lldplink) {
        List<SnmpValue> val = this.get(lldplink.getLldpLocalPortNum());
        if (val == null) {
            LOG.debug("get: [{}], cannot find local instance for lldp local port number {}", (Object)this.getNodeId(), (Object)lldplink.getLldpLocalPortNum());
            LOG.debug("get: [{}], setting default not found Values: portidtype \"InterfaceAlias\", portid=\"Not Found On lldpLocPortTable\"", (Object)this.getNodeId());
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS);
            lldplink.setLldpPortId("\"Not Found On lldpLocPortTable\"");
            lldplink.setLldpPortDescr("");
            return lldplink;
        }
        if (val.get(0) == null || val.get(0).isError() || !val.get(0).isNumeric()) {
            LOG.debug("get: [{}], port id subtype is null or invalid for lldp local port number {}", (Object)this.getNodeId(), (Object)lldplink.getLldpLocalPortNum());
            LOG.debug("get: [{}], setting default not found Values: portidtype \"InterfaceAlias\"", (Object)this.getNodeId());
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS);
        } else {
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.get((Integer)val.get(0).toInt()));
        }
        if (val.get(1) == null || val.get(1).isError()) {
            LOG.debug("get: [{}], port id is null for lldp local port number {}", (Object)this.getNodeId(), (Object)lldplink.getLldpLocalPortNum());
            LOG.debug("get: [{}], setting default not found Values: portid=\"Not Found On lldpLocPortTable\"", (Object)this.getNodeId());
            lldplink.setLldpPortId("\"Not Found On lldpLocPortTable\"");
        } else {
            lldplink.setLldpPortId(LldpRemTableTracker.decodeLldpPortId(lldplink.getLldpPortIdSubType().getValue(), val.get(1)));
        }
        if (val.get(2) != null && !val.get(2).isError()) {
            lldplink.setLldpPortDescr(val.get(2).toDisplayString());
        } else {
            lldplink.setLldpPortDescr("");
        }
        if (val.get(0).isNumeric() && val.get(0).toInt() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL.getValue().intValue()) {
            try {
                lldplink.setLldpPortIfindex(Integer.valueOf(val.get(1).toInt()));
            }
            catch (Exception e) {
                LOG.warn("get: [{}], failed to convert to ifindex local port id {}", (Object)this.getNodeId(), (Object)val.get(1));
            }
        }
        return lldplink;
    }
}

