/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.netmgt.enlinkd.common.NodeCollector;
import org.opennms.netmgt.enlinkd.model.IsIsLink;
import org.opennms.netmgt.enlinkd.service.api.IsisTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.snmp.IsisCircTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisISAdjTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisSysObjectGroupTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryIsis
extends NodeCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryIsis.class);
    private final IsisTopologyService m_isisTopologyService;

    public NodeDiscoveryIsis(IsisTopologyService isisTopologyService, LocationAwareSnmpClient locationAwareSnmpClient, long interval, long initial, Node node) {
        super(locationAwareSnmpClient, interval, initial, node);
        this.m_isisTopologyService = isisTopologyService;
    }

    public void collect() {
        Date now = new Date();
        IsisSysObjectGroupTracker isisSysObject = new IsisSysObjectGroupTracker();
        SnmpAgentConfig peer = this.getSnmpAgentConfig();
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)isisSysObject).withDescription("isisSysObjectCollection").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: Is-Is mib not supported: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: Is-Is mib not supported: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        if (isisSysObject.getIsisSysId() == null) {
            LOG.info("run: node [{}]: Is-Is mib not supported ", (Object)this.getNodeId());
            return;
        }
        this.m_isisTopologyService.store(this.getNodeId(), isisSysObject.getIsisElement());
        final ArrayList links = new ArrayList();
        IsisISAdjTableTracker isisISAdjTableTracker = new IsisISAdjTableTracker(){

            @Override
            public void processIsisAdjRow(IsisISAdjTableTracker.IsIsAdjRow row) {
                links.add(row.getIsisLink());
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)isisISAdjTableTracker).withDescription("isisISAdjTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        IsisCircTableTracker isisCircTableTracker = new IsisCircTableTracker(){

            @Override
            public void processIsisCircRow(IsisCircTableTracker.IsIsCircRow row) {
                IsIsLink link = row.getIsisLink();
                for (IsIsLink adjlink : links) {
                    if (link.getIsisCircIndex().intValue() != adjlink.getIsisCircIndex().intValue()) continue;
                    adjlink.setIsisCircIfIndex(link.getIsisCircIfIndex());
                    adjlink.setIsisCircAdminState(link.getIsisCircAdminState());
                }
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)isisCircTableTracker).withDescription("isisCircTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: isisCircTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: isisCircTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        for (IsIsLink link : links) {
            this.m_isisTopologyService.store(this.getNodeId(), link);
        }
        this.m_isisTopologyService.reconcile(this.getNodeId(), now);
    }

    public String getName() {
        return "NodeDiscoveryIsis";
    }
}

