/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elasticsearch.eventforwarder.internal;

import org.apache.camel.Produce;
import org.opennms.core.camel.DefaultDispatcher;
import org.opennms.features.elasticsearch.eventforwarder.internal.CamelEventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventForwarder
extends DefaultDispatcher
implements CamelEventForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventForwarder.class);
    @Produce(property="endpointUri")
    CamelEventForwarder m_proxy;

    public DefaultEventForwarder(String endpointUri) {
        super(endpointUri);
    }

    @Override
    public void sendNow(Event event) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("forwarding event " + event);
        }
        this.m_proxy.sendNow(event);
    }

    @Override
    public void sendNow(Log eventLog) {
        for (Event event : eventLog.getEvents().getEventCollection()) {
            this.m_proxy.sendNow(event);
        }
    }

    public void sendNowSync(Event event) {
        this.sendNow(event);
    }

    public void sendNowSync(Log eventLog) {
        this.sendNow(eventLog);
    }
}

