/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elasticsearch.eventforwarder;

import org.opennms.features.elasticsearch.eventforwarder.internal.CamelEventForwarder;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class ForwardingEventListener
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingEventListener.class);
    private volatile CamelEventForwarder eventForwarder;
    private volatile EventIpcManager eventIpcManager;
    private volatile NodeDao nodeDao;
    private volatile TransactionTemplate transactionTemplate;

    public CamelEventForwarder getEventForwarder() {
        return this.eventForwarder;
    }

    public void setEventForwarder(CamelEventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public EventIpcManager getEventIpcManager() {
        return this.eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.eventIpcManager = eventIpcManager;
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void init() {
        Assert.notNull((Object)this.eventIpcManager, (String)"eventIpcManager must not be null");
        Assert.notNull((Object)this.eventForwarder, (String)"eventForwarder must not be null");
        this.installMessageSelectors();
        LOG.info("Elasticsearch event forwarder initialized");
    }

    private void installMessageSelectors() {
        this.getEventIpcManager().addEventListener((EventListener)this);
    }

    public void destroy() {
        Assert.notNull((Object)this.eventIpcManager, (String)"eventIpcManager must not be null");
        Assert.notNull((Object)this.eventForwarder, (String)"eventForwarder must not be null");
        this.getEventIpcManager().removeEventListener((EventListener)this);
        LOG.info("Elasticsearch event forwarder uninstalled");
    }

    public void onEvent(Event event) {
        if (event.getDbid() != null && event.getDbid() != 0) {
            this.eventForwarder.sendNow(event);
        }
    }

    public String getName() {
        return "ElasticsearchEventForwarder";
    }
}

