/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elasticsearch.eventforwarder.internal;

import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.bean.BeanInvocation;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.elasticsearch.eventforwarder.internal.IndexNameFunction;
import org.opennms.features.elasticsearch.eventforwarder.internal.NodeCache;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESHeaders {
    Logger logger = LoggerFactory.getLogger(ESHeaders.class);
    private boolean logEventDescription = false;
    private NodeCache cache;
    private IndexNameFunction idxName = new IndexNameFunction();
    private String remainder = "opennms";

    public void process(Exchange exchange) {
        Message in = exchange.getIn();
        String indexName = null;
        String indexType = null;
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            Object incoming = in.getBody();
            if (incoming instanceof BeanInvocation) {
                Object argument = ((BeanInvocation)incoming).getArgs()[0];
                if (argument instanceof Event) {
                    this.logger.debug("Processing event");
                    indexType = "events";
                    Event event = (Event)argument;
                    this.populateBodyFromEvent(body, event);
                    if (event.getNodeid() != null) {
                        try {
                            this.maybeRefreshCache(event);
                            body.putAll(this.cache.getEntry(event.getNodeid()));
                        }
                        catch (Exception e) {
                            this.logger.error("error fetching nodeData categories: ", (Throwable)e);
                        }
                    }
                } else if (argument instanceof NorthboundAlarm) {
                    this.logger.debug("Processing alarm");
                    indexType = "alarms";
                    NorthboundAlarm alarm = (NorthboundAlarm)argument;
                    this.populateBodyFromAlarm(body, alarm);
                    if (alarm.getNodeId() != null) {
                        try {
                            body.putAll(this.cache.getEntry((long)alarm.getNodeId()));
                        }
                        catch (Exception e) {
                            this.logger.error("error fetching nodeData categories: ", (Throwable)e);
                        }
                    }
                }
            } else if (incoming instanceof Map) {
                this.logger.debug("Processing a generic map");
                body.putAll((Map)incoming);
            }
            if (body.containsKey("@timestamp")) {
                this.logger.trace("Computing indexName from @timestamp: " + body.get("@timestamp"));
                indexName = this.idxName.apply(this.remainder, (Date)body.get("@timestamp"));
            } else {
                indexName = this.idxName.apply(this.remainder);
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot compute index name, failing back to default: " + e.getMessage());
            indexName = this.idxName.apply(this.remainder);
        }
        this.logger.trace("Computing indexName from @timestamp: " + body.get("@timestamp") + " yelds " + indexName);
        exchange.getOut().setHeader("indexName", (Object)indexName);
        exchange.getOut().setHeader("indexType", (Object)indexType);
        exchange.getOut().setBody(body);
    }

    private void populateBodyFromAlarm(Map<String, Object> body, NorthboundAlarm alarm) {
        body.put("id", alarm.getId());
        body.put("eventuei", alarm.getUei());
        body.put("@timestamp", alarm.getLastOccurrence());
        body.put("count", alarm.getCount());
        Calendar cal = Calendar.getInstance();
        cal.setTime(alarm.getLastOccurrence());
        body.put("dow", cal.get(7));
        body.put("hour", cal.get(11));
        body.put("dom", cal.get(5));
        body.put("poller", alarm.getPoller());
        body.put("ipaddr", alarm.getIpAddr() != null ? alarm.getIpAddr() : null);
        body.put("servicename", alarm.getService());
        body.put("eventseverity_text", alarm.getSeverity().getLabel());
        body.put("eventseverity", alarm.getSeverity().getId());
        body.put("nodeid", alarm.getNodeId());
        body.put("ackuser", alarm.getAckUser());
        body.put("acktime", alarm.getAckTime());
        body.put("appdn", alarm.getAppDn());
        body.put("suppressedby", alarm.getSuppressedBy());
        body.put("suppressed", alarm.getSuppressed());
    }

    private void maybeRefreshCache(Event event) {
        String uei = event.getUei();
        if (uei != null && uei.startsWith("uei.opennms.org/nodes/") && (uei.endsWith("Added") || uei.endsWith("Deleted") || uei.endsWith("Updated") || uei.endsWith("Changed"))) {
            this.cache.refreshEntry(event.getNodeid());
        }
    }

    private void populateBodyFromEvent(Map<String, Object> body, Event event) {
        body.put("id", event.getDbid());
        body.put("eventuei", event.getUei());
        body.put("@timestamp", event.getCreationTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(event.getCreationTime());
        body.put("dow", cal.get(7));
        body.put("hour", cal.get(11));
        body.put("dom", cal.get(5));
        body.put("eventsource", event.getSource());
        body.put("ipaddr", event.getInterfaceAddress() != null ? InetAddressUtils.str((InetAddress)event.getInterfaceAddress()) : null);
        body.put("servicename", event.getService());
        body.put("eventseverity_text", event.getSeverity());
        body.put("eventseverity", OnmsSeverity.get((String)event.getSeverity()).getId());
        if (this.isLogEventDescription()) {
            body.put("eventdescr", event.getDescr());
        }
        body.put("nodeid", event.getNodeid());
        body.put("host", event.getHost());
        for (Parm parm : event.getParmCollection()) {
            body.put("p_" + parm.getParmName(), parm.getValue().getContent());
        }
        body.put("interface", event.getInterface());
        body.put("logmsg", event.getLogmsg() != null ? event.getLogmsg().getContent() : null);
        body.put("logmsgdest", event.getLogmsg() != null ? event.getLogmsg().getDest() : null);
    }

    public String getRemainder() {
        return this.remainder;
    }

    public void setRemainder(String remainder) {
        this.remainder = remainder;
    }

    public boolean isLogEventDescription() {
        return this.logEventDescription;
    }

    public void setLogEventDescription(boolean logEventDescription) {
        this.logEventDescription = logEventDescription;
    }

    public void setLogEventDescription(String logEventDescription) {
        this.logEventDescription = Boolean.parseBoolean(logEventDescription);
    }

    public NodeCache getCache() {
        return this.cache;
    }

    public void setCache(NodeCache cache) {
        this.cache = cache;
    }
}

