/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elasticsearch.eventforwarder.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.component.properties.PropertiesFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexNameFunction
implements PropertiesFunction {
    Logger logger = LoggerFactory.getLogger(IndexNameFunction.class);
    private SimpleDateFormat df = null;

    public IndexNameFunction() {
        this.df = new SimpleDateFormat("yyyy.MM");
    }

    public IndexNameFunction(String dateFormat) {
        this.df = new SimpleDateFormat(dateFormat == null ? "yyyy.MM" : dateFormat);
    }

    public String getName() {
        return "index";
    }

    public String apply(String remainder) {
        String result = null;
        result = remainder.toLowerCase() + "-" + this.df.format(new Date());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("IndexNameFunction.apply=" + result);
        }
        return result;
    }

    public String apply(String remainder, Date date) {
        String result = null;
        result = remainder.toLowerCase() + "-" + this.df.format(date);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("IndexNameFunction.apply=" + result);
        }
        return result;
    }
}

