/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elasticsearch.eventforwarder.internal;

import org.apache.camel.InOnly;
import org.apache.camel.Produce;
import org.opennms.core.camel.DefaultDispatcher;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InOnly
public class DefaultEventForwarder
extends DefaultDispatcher
implements EventForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventForwarder.class);
    @Produce(property="endpointUri")
    EventForwarder m_proxy;

    public DefaultEventForwarder(String endpointUri) {
        super(endpointUri);
    }

    public void sendNow(Event event) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("forwarding event " + event);
        }
        this.m_proxy.sendNow(event);
    }

    public void sendNow(Log eventLog) {
        for (Event event : eventLog.getEvents().getEventCollection()) {
            this.m_proxy.sendNow(event);
        }
    }
}

